/*
 * Decompiled with CFR 0.152.
 */
package com.anf.oauth.client;

import com.anf.oauth.client.OauthClient;
import com.anf.oauth.client.OauthParamsClient;
import com.anf.oauth.client.exception.OauthClientException;
import com.anf.oauth.client.factory.OauthClientFactory;
import com.anf.oauth.client.params.OauthParams;
import com.anf.oauth.json.CredentialRequest;
import com.anf.oauth.json.JSONFactory;
import com.anf.oauth.json.ResponseWrapper;
import com.anf.oauth.json.TokenResponse;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractClient
implements OauthParamsClient {
    private static final Logger log = LogManager.getLogger(AbstractClient.class);
    protected String url = "https://restapi.anf.es/";
    protected long timeout = 30000L;
    private boolean printRequest;
    private boolean printResponse;
    private String jwt;
    private Date expirationDate = null;
    private OauthClient oauthClient;
    private CredentialRequest oauthRequest;

    protected AbstractClient(String url, long timeout) {
        this.url = url;
        this.timeout = timeout;
        log.info("oauth client url " + url + " timeout:" + timeout);
    }

    protected AbstractClient(String url, long timeout, OauthParams oauthParams) {
        this(url, timeout);
        this.setOauthParams(oauthParams);
    }

    @Override
    public void setOauthParams(OauthParams oauthParams) {
        OauthClientFactory factory = new OauthClientFactory();
        this.oauthClient = factory.getClient(oauthParams.getAuthUrl(), 30000L);
        this.oauthRequest = new CredentialRequest("client_credentials", oauthParams.getClientId(), oauthParams.getClientSecret(), oauthParams.getScope());
    }

    public void setDateFormat(DateFormat dateFormat) {
        JSONFactory.setDateFormat(dateFormat);
    }

    public String getAccessToken() {
        if (this.oauthRequest == null) {
            return null;
        }
        if (this.checkIfRequestNewToken()) {
            try {
                log.info("requesting new access token");
                Date requestDate = new Date();
                TokenResponse accessToken = this.oauthClient.requestAccessToken(this.oauthRequest);
                this.jwt = accessToken.getAccess_token();
                DecodedJWT decode = JWT.decode((String)this.jwt);
                long adjustment = decode.getIssuedAt().getTime() - requestDate.getTime();
                Calendar cal = Calendar.getInstance();
                cal.setTime(decode.getExpiresAt());
                cal.add(12, -1);
                cal.add(14, (int)(-adjustment));
                this.expirationDate = cal.getTime();
                log.debug("new expiration date: {}", (Object)this.expirationDate);
                this.waitOffsetTime();
            }
            catch (Throwable e) {
                log.catching(e);
                throw new OauthClientException(e);
            }
        }
        return this.jwt;
    }

    private void waitOffsetTime() {
        String offsetTimeLocal = System.getProperty("client.offset.time", "1000");
        if (offsetTimeLocal != null) {
            try {
                int offsetTime = Integer.parseInt(offsetTimeLocal);
                Thread.sleep(offsetTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean checkIfRequestNewToken() {
        if (this.jwt == null) {
            log.info("token is null");
            return true;
        }
        if (this.expirationDate == null) {
            log.info("exp date is null");
            return true;
        }
        if (this.expired()) {
            log.info("token expired on: " + this.expirationDate + " and now is " + new Date());
            return true;
        }
        return false;
    }

    private boolean expired() {
        return new Date().after(this.expirationDate);
    }

    protected String getBearerHeader() {
        return "Bearer " + this.getAccessToken();
    }

    protected <Request, Response> AtomicReference<Response> handleJsonRequest(Request request, Class<Response> respClass) throws IOException {
        return this.handleJsonRequest("", request, respClass);
    }

    protected <Request, Response> AtomicReference<Response> handleJsonRequest(String uri, Request request, Class<Response> respClass) throws IOException {
        AtomicReference<Response> result = new AtomicReference<Response>();
        result.set(this.handleRequest(uri, request, respClass, String::new, "POST", "request"));
        return result;
    }

    public <Request, Response> Response handleRequest(String uri, Request request, Class<Response> respClass, Function<byte[], String> jsonTransformer, String method, String jsonRoot) throws IOException {
        byte[] requestContent = null;
        if (request != null) {
            String json = JSONFactory.buildJSON(request, jsonRoot);
            requestContent = json.getBytes(StandardCharsets.UTF_8);
            if (this.printRequest) {
                log.info("REQUEST:\n" + new String(requestContent));
            }
        }
        byte[] content = this.handleRawRequest(uri, method, "application/json", requestContent);
        Object json = null;
        json = jsonTransformer == null ? "{\"response\":" + new String(content) + "}" : jsonTransformer.apply(content);
        if (this.printResponse) {
            log.info("RESPONSE:\n" + (String)json);
        }
        JavaType type = JSONFactory.getMapper().getTypeFactory().constructParametricType(ResponseWrapper.class, new Class[]{respClass});
        ResponseWrapper wrapper = (ResponseWrapper)JSONFactory.getMapper().readValue((String)json, type);
        return (Response)wrapper.getResponse();
    }

    public byte[] handleRawRequest(String uri, String method, String contentType, byte[] requestContent) throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Content-type", contentType);
        return this.handleRawRequest(uri, method, requestContent, headers);
    }

    public byte[] handleRawRequest(String uri, String method, byte[] requestContent, Map<String, String> headers) throws IOException {
        return this.handleRawRequest(uri, method, requestContent, headers, true);
    }

    private byte[] handleRawRequest(String uri, String method, byte[] requestContent, Map<String, String> headers, boolean retryOauth) throws IOException {
        log.info("oauth url=" + this.url + " uri:" + uri);
        URL urlConn = new URL(this.url + uri);
        HttpURLConnection httpConn = (HttpURLConnection)urlConn.openConnection();
        httpConn.setConnectTimeout((int)this.timeout);
        httpConn.setReadTimeout((int)this.timeout);
        httpConn.setDoInput(true);
        httpConn.setDoOutput(true);
        if (headers != null) {
            headers.forEach(httpConn::setRequestProperty);
        }
        if (this.oauthRequest != null) {
            httpConn.setRequestProperty("Authorization", this.getBearerHeader());
        }
        httpConn.setRequestMethod(method);
        if (requestContent != null) {
            OutputStream os = httpConn.getOutputStream();
            os.write(requestContent);
            os.flush();
        } else {
            httpConn.connect();
        }
        int responseCode = httpConn.getResponseCode();
        log.debug("response code {} for url {}", (Object)responseCode, (Object)this.url);
        if (responseCode == 401) {
            if (this.oauthRequest == null || !retryOauth) {
                throw new OauthClientException("ERR_UNAUTHORIZED");
            }
            this.jwt = null;
            return this.handleRawRequest(uri, method, requestContent, headers, false);
        }
        byte[] content = IOUtils.toByteArray((InputStream)httpConn.getInputStream());
        httpConn.disconnect();
        return content;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isPrintRequest() {
        return this.printRequest;
    }

    public void setPrintRequest(boolean printRequest) {
        this.printRequest = printRequest;
    }

    public boolean isPrintResponse() {
        return this.printResponse;
    }

    public void setPrintResponse(boolean printResponse) {
        this.printResponse = printResponse;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

