/*
 * Decompiled with CFR 0.152.
 */
package com.anf.centralizados.converters;

import com.anf.centralizados.converters.CertFormatParser;
import com.anf.centralizados.converters.CertificateConverterBase;
import com.anf.centralizados.enums.CertFormat;
import com.anf.centralizados.enums.EncodeType;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class CertificateConverter {
    public static X509Certificate from(String certData, String encodeTypeString, String certFormatString) throws Exception {
        EncodeType encodeType = EncodeType.valueOf(encodeTypeString);
        CertFormat certFormat = CertFormatParser.getCertFormat(certFormatString);
        byte[] certDataArray = CertificateConverter.fromString(certData, encodeType);
        X509Certificate cert = CertificateConverter.fromByteArray(certDataArray, certFormat);
        return cert;
    }

    public static List<X509Certificate> fromList(List<String> certsData, String encodeTypeString, String certFormatString, List<X509Certificate> res) throws Exception {
        EncodeType encodeType = EncodeType.valueOf(encodeTypeString);
        CertFormat certFormat = CertFormatParser.getCertFormat(certFormatString);
        List<byte[]> certsDataArray = CertificateConverter.fromStringList(certsData, encodeType, new ArrayList<byte[]>());
        CertificateConverter.fromByteArrayList(certsDataArray, certFormat, res);
        return res;
    }

    public static String to(X509Certificate cert, String encodeTypeString, String certFormatString) throws Exception {
        EncodeType encodeType = EncodeType.valueOf(encodeTypeString);
        CertFormat certFormat = CertFormatParser.getCertFormat(certFormatString);
        byte[] certDataArray = CertificateConverter.toByteArray(cert, certFormat);
        String certData = CertificateConverter.to_String(certDataArray, encodeType);
        return certData;
    }

    public static List<String> toList(List<X509Certificate> certs, String encodeTypeString, String certFormatString, List<String> res) throws Exception {
        EncodeType encodeType = EncodeType.valueOf(encodeTypeString);
        CertFormat certFormat = CertFormatParser.getCertFormat(certFormatString);
        List<byte[]> certsDataArray = CertificateConverter.toByteArrayList(certs, certFormat, new ArrayList<byte[]>());
        CertificateConverter.to_StringList(certsDataArray, encodeType, res);
        return res;
    }

    public static byte[] fromString(String certData, EncodeType encodeType) {
        byte[] certDataArray = encodeType == EncodeType.HEXADECIMAL ? Hex.decode((String)certData) : Base64.getDecoder().decode(certData);
        return certDataArray;
    }

    public static List<byte[]> fromStringList(List<String> certsData, EncodeType encodeType, List<byte[]> res) {
        for (String cert : certsData) {
            res.add(CertificateConverter.fromString(cert, encodeType));
        }
        return res;
    }

    public static X509Certificate fromByteArray(byte[] certDataArray, CertFormat certFormat) throws Exception {
        X509Certificate cert = certFormat == CertFormat.DER ? CertificateConverterBase.fromDER(certDataArray) : CertificateConverterBase.fromPEM(certDataArray);
        return cert;
    }

    public static List<X509Certificate> fromByteArrayList(List<byte[]> certsDataArray, CertFormat certFormat, List<X509Certificate> res) throws Exception {
        for (byte[] cert : certsDataArray) {
            res.add(CertificateConverter.fromByteArray(cert, certFormat));
        }
        return res;
    }

    public static byte[] toByteArray(X509Certificate cert, CertFormat certFormat) throws Exception {
        byte[] certDataArray = certFormat == CertFormat.DER ? CertificateConverterBase.toDER(cert) : CertificateConverterBase.toPEM(cert);
        return certDataArray;
    }

    public static List<byte[]> toByteArrayList(List<X509Certificate> certs, CertFormat certFormat, List<byte[]> res) throws Exception {
        for (X509Certificate cert : certs) {
            res.add(CertificateConverter.toByteArray(cert, certFormat));
        }
        return res;
    }

    public static String to_String(byte[] certDataArray, EncodeType encodeType) {
        String certData = encodeType == EncodeType.HEXADECIMAL ? Hex.toHexString((byte[])certDataArray) : Base64.getEncoder().encodeToString(certDataArray);
        return certData;
    }

    public static List<String> to_StringList(List<byte[]> certsDataArray, EncodeType encodeType, List<String> res) {
        for (byte[] certDataArray : certsDataArray) {
            res.add(CertificateConverter.to_String(certDataArray, encodeType));
        }
        return res;
    }
}

