/*
 * Decompiled with CFR 0.152.
 */
package com.anf.centralizados.converters;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;

public class CertConverter {
    public static X509Certificate fromDER(byte[] certData) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certData));
    }

    public static X509Certificate fromPEM(byte[] certData) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certData));
    }

    public static X509Certificate[] fromPKCS7(byte[] certData) throws Exception {
        CMSSignedData data = new CMSSignedData((InputStream)new ByteArrayInputStream(certData));
        Store store = data.getCertificates();
        Collection hold = store.getMatches(null);
        Iterator it = hold.iterator();
        X509Certificate[] chain = new X509Certificate[hold.size()];
        int x = 0;
        while (it.hasNext()) {
            X509CertificateHolder hold1 = (X509CertificateHolder)it.next();
            chain[x] = new JcaX509CertificateConverter().setProvider("BC").getCertificate(hold1);
            ++x;
        }
        return chain;
    }
}

