/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.ssl;

import com.anf.cert.profile.EVSSLProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.EVAttributes;
import com.anf.cert.profile.extensions.CertExtension;
import com.anf.cert.profile.impl.ssl.BaselineSSLProfile;
import com.anf.cryptotoken.oid.ProfilePolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class EVSSLProfileImpl
extends BaselineSSLProfile
implements EVSSLProfile {
    protected EVAttributes evAttributes;

    public EVSSLProfileImpl() {
    }

    public EVSSLProfileImpl(CertAttributes certAttributes, EVAttributes evAttributes, String ... domains) {
        super(certAttributes, domains);
        this.evAttributes = evAttributes;
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.SSL_EV_OLD;
    }

    @Override
    public String getTypeName() {
        return "SSL_EV";
    }

    @Override
    protected void addFirstSubjectFields(List<RDN> subjectFields) {
        if (this.evAttributes != null) {
            if (this.evAttributes.getBusinessCategory() != null) {
                this.addSubjectField(subjectFields, BCStyle.BUSINESS_CATEGORY, this.evAttributes.getBusinessCategory(), true);
            }
            if (this.evAttributes.getJurisdictionCountryName() != null) {
                this.addSubjectField(subjectFields, EVSSLProfile.jurisdictionCountryName, this.evAttributes.getJurisdictionCountryName(), true);
            }
            if (this.evAttributes.getJurisdictionLocalityName() != null) {
                this.addSubjectField(subjectFields, EVSSLProfile.jurisdictionLocalityName, this.evAttributes.getJurisdictionLocalityName(), true);
            }
            if (this.evAttributes.getJurisdictionStateOrProvinceName() != null) {
                this.addSubjectField(subjectFields, EVSSLProfile.jurisdictionStateOrProvinceName, this.evAttributes.getJurisdictionStateOrProvinceName(), true);
            }
        }
    }

    @Override
    public EVAttributes getEvAttributes() {
        return this.evAttributes;
    }

    @Override
    @JsonIgnore
    public CertExtension getCabFOrgIdExtension() {
        String organizationIdentifier;
        if (this.certAttributes != null && (organizationIdentifier = this.getOrganizationIdentifier()) != null) {
            ASN1EncodableVector values = new ASN1EncodableVector();
            values.add((ASN1Encodable)new DERPrintableString(this.getRegistrationSchemeId()));
            values.add((ASN1Encodable)new DERPrintableString(this.certAttributes.getCountry()));
            values.add((ASN1Encodable)new DERUTF8String(this.getRegistrationReference()));
            DERSequence value = new DERSequence(values);
            return CertExtension.build("2.23.140.3.1", (ASN1Encodable)value, false);
        }
        return null;
    }

    protected String getRegistrationReference() {
        return this.certAttributes.getSerialNumber();
    }

    @Override
    protected void addLastSubjectFields(List<RDN> subjectFields) {
        String organizationIdentifier = this.getOrganizationIdentifier();
        if (organizationIdentifier != null) {
            this.addSubjectField(subjectFields, new ASN1ObjectIdentifier("2.5.4.97"), organizationIdentifier, true);
        }
    }

    @Override
    public String getOrganizationIdentifier() {
        if (this.getRegistrationReference() != null && !this.getRegistrationReference().isEmpty() && this.certAttributes.getCountry() != null) {
            return this.getRegistrationSchemeId() + this.certAttributes.getCountry() + "-" + this.getRegistrationReference();
        }
        return null;
    }

    public String getRegistrationSchemeId() {
        return "VAT";
    }

    @Override
    protected String getOUSuffix() {
        return null;
    }

    @Override
    protected String defaultOrgUnit() {
        return null;
    }
}

