/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.sede;

import com.anf.cert.profile.BusinessCategory;
import com.anf.cert.profile.SedeProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.EVAttributes;
import com.anf.cert.profile.attributes.SedeAttributes;
import com.anf.cert.profile.impl.ssl.EVSSLProfileImpl;
import com.anf.cryptotoken.oid.ProfilePolicy;
import java.util.List;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class SedeEVMedioProfile
extends EVSSLProfileImpl
implements SedeProfile {
    private SedeAttributes sedeAttributes;

    public SedeEVMedioProfile(CertAttributes certAttributes, SedeAttributes sedeAttributes, EVAttributes evAttributes, String ... domains) {
        super(certAttributes, evAttributes, domains);
        this.sedeAttributes = sedeAttributes;
    }

    public SedeEVMedioProfile() {
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.SEDE_EV_MEDIO_OLD;
    }

    @Override
    public String getTypeName() {
        return "SEDE_EV_MEDIO";
    }

    @Override
    protected void addFirstSubjectFields(List<RDN> subjectFields) {
        this.evAttributes.setBusinessCategory(BusinessCategory.GOV_ENTITY.getValue());
        super.addFirstSubjectFields(subjectFields);
        if (this.sedeAttributes != null) {
            String name = this.sedeAttributes.getName();
            String surname = this.sedeAttributes.getSurname();
            String descName = this.sedeAttributes.getDescriptiveName();
            String email = this.sedeAttributes.getEmail();
            this.addSubjectField(subjectFields, BCStyle.EmailAddress, email, true);
        }
    }

    @Override
    protected void addLastSubjectFields(List<RDN> subjectFields) {
        super.addLastSubjectFields(subjectFields);
    }

    @Override
    public SedeAttributes getSedeAttributes() {
        return this.sedeAttributes;
    }

    @Override
    protected String defaultOrgUnit() {
        return null;
    }

    @Override
    protected String getOUSuffix() {
        return null;
    }
}

