/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.profile.impl.seal;

import com.anf.cert.profile.APSealProfile;
import com.anf.cert.profile.attributes.CertAttributes;
import com.anf.cert.profile.attributes.SealAttributes;
import com.anf.cert.profile.impl.seal.SealProfileImpl;
import com.anf.cryptotoken.oid.ProfilePolicy;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x509.GeneralName;

public class SealProfileAPMedio
extends SealProfileImpl
implements APSealProfile {
    private boolean includeSubscriberFields = true;

    public SealProfileAPMedio() {
    }

    public SealProfileAPMedio(CertAttributes certAttributes, SealAttributes attributes) {
        super(certAttributes, attributes);
    }

    @Override
    protected ProfilePolicy profilePolicy() {
        return ProfilePolicy.QSeal_AP_Software;
    }

    @Override
    public String getTypeName() {
        return "QSEAL_AP_MEDIO";
    }

    @Override
    public List<GeneralName> getSubjectAltNames() {
        String mail;
        String serviceName;
        String nif;
        List<GeneralName> subjectAltNames = super.getSubjectAltNames();
        X500NameBuilder builder = new X500NameBuilder();
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(this.getPolicyOidLevel());
        builder.addRDN(oid.branch("1"), this.nature());
        String org = this.certAttributes.getOrganization();
        if (org != null) {
            builder.addRDN(oid.branch("2"), org);
        }
        if ((nif = this.certAttributes.getSerialNumber()) != null) {
            builder.addRDN(oid.branch("3"), nif);
        }
        String dni = this.sealAttributes.getDni();
        if (this.includeSubscriberFields && dni != null) {
            builder.addRDN(oid.branch("4"), dni);
        }
        if ((serviceName = this.certAttributes.getCommonName()) != null) {
            builder.addRDN(oid.branch("5"), serviceName);
        }
        String name = this.sealAttributes.getName();
        if (this.includeSubscriberFields && name != null) {
            builder.addRDN(oid.branch("6"), name);
        }
        if (this.includeSubscriberFields) {
            String surname = this.sealAttributes.getSurname();
            String lastName1 = this.sealAttributes.getLastName1();
            String lastName2 = this.sealAttributes.getLastName2();
            if (lastName1 == null || lastName2 == null) {
                String[] split = surname.split(" ");
                if (split.length > 0) {
                    lastName1 = split[0];
                }
                if (split.length > 1) {
                    lastName2 = split[1];
                }
            }
            if (lastName1 != null && !lastName1.isEmpty()) {
                builder.addRDN(oid.branch("7"), lastName1);
            }
            if (lastName2 != null && !lastName2.isEmpty()) {
                builder.addRDN(oid.branch("8"), lastName2);
            }
        }
        if ((mail = this.sealAttributes.getEmail()) != null) {
            builder.addRDN(oid.branch("9"), mail);
        }
        X500Name dirName = builder.build();
        GeneralName gn = new GeneralName(4, (ASN1Encodable)dirName.toASN1Primitive());
        subjectAltNames.add(gn);
        return subjectAltNames;
    }

    @Override
    public String nature() {
        return "SELLO ELECTRONICO DE NIVEL MEDIO";
    }

    @Override
    public String getPolicyOidLevel() {
        return "2.16.724.1.3.5.6.2";
    }

    @Override
    protected void addCIF(List<RDN> subjectFields) {
        if (this.certAttributes.getSerialNumber() == null || !this.certAttributes.getSerialNumber().startsWith("P") && !this.certAttributes.getSerialNumber().startsWith("Q") && !this.certAttributes.getSerialNumber().startsWith("S")) {
            throw new RuntimeException("ERR_INVALID_NIF:" + this.certAttributes.getSerialNumber());
        }
        super.addCIF(subjectFields);
    }

    @Override
    public List<RDN> createSubjectFields() {
        if (this.certAttributes.getCountry() == null || !this.certAttributes.getCountry().equals("ES")) {
            throw new RuntimeException("ERR_INVALID_COUNTRY:" + this.certAttributes.getCountry());
        }
        return super.createSubjectFields();
    }

    public boolean isIncludeSubscriberFields() {
        return this.includeSubscriberFields;
    }

    public void setIncludeSubscriberFields(boolean includeSubscriberFields) {
        this.includeSubscriberFields = includeSubscriberFields;
    }
}

