/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.validation.scope.EncapsulatedTimestampScopeFinder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampInclude;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XAdESTimestampScopeFinder
extends EncapsulatedTimestampScopeFinder {
    protected List<SignatureScope> filterCoveredSignatureScopes(TimestampToken timestampToken) {
        List timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty((Collection)timestampIncludes)) {
            ArrayList<SignatureScope> individualSignatureScopes = new ArrayList<SignatureScope>();
            List signatureScopes = this.signature.getSignatureScopes();
            if (Utils.isCollectionNotEmpty((Collection)signatureScopes)) {
                for (ReferenceValidation referenceValidation : this.signature.getReferenceValidations()) {
                    XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
                    if (!this.isContentTimestampedReference(xadesReferenceValidation, timestampIncludes)) continue;
                    for (SignatureScope signatureScope : signatureScopes) {
                        if (!Utils.endsWithIgnoreCase((String)xadesReferenceValidation.getUri(), (String)signatureScope.getDocumentName())) continue;
                        individualSignatureScopes.add(signatureScope);
                    }
                }
            }
            return individualSignatureScopes;
        }
        return super.filterCoveredSignatureScopes(timestampToken);
    }

    private boolean isContentTimestampedReference(XAdESReferenceValidation xadesReferenceValidation, List<TimestampInclude> includes) {
        if (xadesReferenceValidation.getId() != null) {
            for (TimestampInclude timestampInclude : includes) {
                if (!xadesReferenceValidation.getId().equals(timestampInclude.getURI())) continue;
                return true;
            }
        }
        return false;
    }
}

