/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSObject;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EnvelopingSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopingSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        super(params, document, certificateVerifier);
    }

    @Override
    protected void incorporateSignedObjects() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            DSSDocument content;
            if (reference.getObject() != null) {
                this.incorporateObject(reference.getObject());
                continue;
            }
            if (this.params.isManifestSignature()) {
                Document doc = DomUtils.buildDOM((DSSDocument)reference.getContents());
                Element root = doc.getDocumentElement();
                NodeList referencesNodes = root.getChildNodes();
                String idAttribute = root.getAttribute(XMLDSigAttribute.ID.getAttributeName());
                Element manifestDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.MANIFEST);
                manifestDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), idAttribute);
                for (int i = 0; i < referencesNodes.getLength(); ++i) {
                    Node copyNode = this.documentDom.importNode(referencesNodes.item(i), true);
                    manifestDom.appendChild(copyNode);
                }
                Element dom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
                dom.appendChild(manifestDom);
                this.signatureDom.appendChild(dom);
                continue;
            }
            DSSObject object = new DSSObject();
            if (this.params.isEmbedXML()) {
                content = reference.getContents();
            } else {
                String base64EncodedOriginalDocument = Utils.toBase64((byte[])DSSUtils.toByteArray((DSSDocument)reference.getContents()));
                content = new InMemoryDocument(base64EncodedOriginalDocument.getBytes());
            }
            object.setContent(content);
            object.setId(reference.getUri().substring(1));
            this.incorporateObject(object);
        }
    }
}

