/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.evidencerecord.AbstractSignatureEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.spi.validation.evidencerecord.ByteArrayComparator;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.definition.xadesen.XAdESEvidencerecordNamespaceElement;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.dss.xml.utils.XMLCanonicalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESEvidenceRecordDigestBuilder
extends AbstractSignatureEvidenceRecordDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESEvidenceRecordDigestBuilder.class);
    private List<DSSDocument> detachedContent;
    private String signatureId;

    public XAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument) {
        super(signatureDocument);
    }

    public XAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument, DigestAlgorithm digestAlgorithm) {
        super(signatureDocument, digestAlgorithm);
    }

    public XAdESEvidenceRecordDigestBuilder setDetachedContent(List<DSSDocument> detachedContent) {
        this.detachedContent = detachedContent;
        return this;
    }

    public XAdESEvidenceRecordDigestBuilder setSignatureId(String signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    public XAdESEvidenceRecordDigestBuilder setParallelEvidenceRecord(boolean parallelEvidenceRecord) {
        return (XAdESEvidenceRecordDigestBuilder)super.setParallelEvidenceRecord(parallelEvidenceRecord);
    }

    public Digest build() {
        AdvancedSignature signature;
        XMLDocumentAnalyzer documentAnalyzer = new XMLDocumentAnalyzer(this.signatureDocument);
        documentAnalyzer.setDetachedContents(this.detachedContent);
        List signatures = documentAnalyzer.getSignatures();
        if (Utils.collectionSize((Collection)signatures) == 0) {
            throw new IllegalInputException("The provided document does not contain any signature! Unable to compute message-imprint for an integrated evidence-record.");
        }
        if (Utils.isStringNotEmpty((String)this.signatureId)) {
            signature = documentAnalyzer.getSignatureById(this.signatureId);
            if (signature == null) {
                throw new IllegalArgumentException(String.format("No signature with Id '%s' found in the document!", this.signatureId));
            }
        } else {
            if (Utils.collectionSize((Collection)signatures) > 1) {
                throw new IllegalInputException("The provided document contains multiple signatures! Please use #setSignatureId method in order to provide the identifier.");
            }
            signature = (AdvancedSignature)signatures.get(0);
        }
        return this.getXmlSignatureMessageImprint((XAdESSignature)signature);
    }

    protected DSSMessageDigest getXmlSignatureMessageImprint(XAdESSignature signature) {
        try {
            XAdESUnsignedSigProperties unsignedSignatureProperties;
            ArrayList<byte[]> dataObjectsGroup = new ArrayList<byte[]>();
            byte[] bytes = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 1): Processing ds:Reference's within ds:SignedInfo");
            }
            String canonicalizationAlgorithm = this.getCanonicalizationAlgorithm(signature);
            for (Reference reference : signature.getReferences()) {
                bytes = this.getReferenceBytes(reference, canonicalizationAlgorithm);
                dataObjectsGroup.add(bytes);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 2): Canonicalization of ds:SignedInfo, ds:SignatureValue, ds:KeyInfo element");
            }
            bytes = this.getCanonicalizedValue(signature, XMLDSigPath.SIGNED_INFO_PATH, canonicalizationAlgorithm);
            dataObjectsGroup.add(bytes);
            bytes = this.getCanonicalizedValue(signature, XMLDSigPath.SIGNATURE_VALUE_PATH, canonicalizationAlgorithm);
            dataObjectsGroup.add(bytes);
            bytes = this.getCanonicalizedValue(signature, XMLDSigPath.KEY_INFO_PATH, canonicalizationAlgorithm);
            dataObjectsGroup.add(bytes);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 3): Processing of unsigned qualifying properties");
            }
            if ((unsignedSignatureProperties = this.getUnsignedSignatureProperties(signature)) != null) {
                for (XAdESAttribute xadesAttribute : unsignedSignatureProperties.getAttributes()) {
                    bytes = this.getCanonicalizedValue(xadesAttribute.getElement(), canonicalizationAlgorithm);
                    dataObjectsGroup.add(bytes);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 5): Processing of ds:Object's");
            }
            for (Node object : this.getObjects(signature)) {
                if (this.containsQualifyingProperties(object, signature.getXAdESPaths())) continue;
                bytes = this.getCanonicalizedValue(object, canonicalizationAlgorithm);
                dataObjectsGroup.add(bytes);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 6): Processing of ds:Manifest's");
            }
            for (Reference reference : signature.getReferences()) {
                if (!reference.typeIsReferenceToManifest()) continue;
                List<byte[]> manifestDataObjects = this.getManifestDataObjects(signature, reference, canonicalizationAlgorithm);
                dataObjectsGroup.addAll(manifestDataObjects);
            }
            DSSMessageDigest dSSMessageDigest = this.computeDigestValueGroupHash(dataObjectsGroup);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Evidence-record signature data group digest: %s", dSSMessageDigest));
            }
            return dSSMessageDigest;
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Unable to compute message-imprint for an evidence-record. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    protected String getCanonicalizationAlgorithm(XAdESSignature signature) {
        Element signedInfo = signature.getSignedInfo();
        if (signedInfo == null) {
            throw new IllegalStateException("ds:SignedInfo element shall be defined within a signature!");
        }
        String canonicalizationMethod = DomUtils.getValue((Node)signedInfo, (String)XMLDSigPath.CANONICALIZATION_ALGORITHM_PATH);
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            LOG.warn("No canonicalization method found within ds:SignedInfo element. Re-use the default canonicalization algorithm 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315'");
            canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        return canonicalizationMethod;
    }

    private byte[] getReferenceBytes(Reference reference, String canonicalizationAlgorithm) throws XMLSecurityException {
        try {
            byte[] referencedBytes = reference.getReferencedBytes();
            if (this.isResultXmlNodeSet(reference, referencedBytes)) {
                referencedBytes = XMLCanonicalizer.createInstance((String)canonicalizationAlgorithm).canonicalize(referencedBytes);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("ReferencedBytes : {}", (Object)new String(referencedBytes));
            }
            return referencedBytes;
        }
        catch (ReferenceNotInitializedException e) {
            throw new DSSException(String.format("An error occurred on ds:Reference processing. In case of detached signature, please use #setDetachedContent method to provide original documents. More information : %s", e.getMessage()), (Throwable)e);
        }
    }

    private byte[] getCanonicalizedValue(XAdESSignature signature, String xPathString, String canonicalizationAlgorithm) {
        Element element = DomUtils.getElement((Node)signature.getSignatureElement(), (String)xPathString);
        return this.getCanonicalizedValue(element, canonicalizationAlgorithm);
    }

    private byte[] getCanonicalizedValue(Node node, String canonicalizationAlgorithm) {
        if (node != null) {
            byte[] bytes = XMLCanonicalizer.createInstance((String)canonicalizationAlgorithm).canonicalize(node);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Canonicalized subtree string : \n{}", (Object)new String(bytes));
            }
            return bytes;
        }
        return null;
    }

    private XAdESUnsignedSigProperties getUnsignedSignatureProperties(XAdESSignature signature) {
        NodeList unsignedSignatureProperties;
        Node lastSealingEvidenceRecordNode;
        Element unsignedSignaturePropertiesDom = DomUtils.getElement((Node)signature.getSignatureElement(), (String)signature.getXAdESPaths().getUnsignedSignaturePropertiesPath());
        if (unsignedSignaturePropertiesDom == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No xades:UnsignedSignatureProperties is present to compute the message-imprint for an evidence-record");
            }
            return null;
        }
        if (this.parallelEvidenceRecord && (lastSealingEvidenceRecordNode = this.getLastSealingEvidenceRecordNode(unsignedSignatureProperties = unsignedSignaturePropertiesDom.getChildNodes())) != null) {
            boolean evidenceRecordNodeReached = false;
            for (int i = 0; i < unsignedSignatureProperties.getLength(); ++i) {
                Node childNode = unsignedSignatureProperties.item(i);
                if (!evidenceRecordNodeReached && lastSealingEvidenceRecordNode != childNode) continue;
                unsignedSignaturePropertiesDom.removeChild(childNode);
                evidenceRecordNodeReached = true;
            }
        }
        return new XAdESUnsignedSigProperties(unsignedSignaturePropertiesDom, signature.getXAdESPaths());
    }

    private Node getLastSealingEvidenceRecordNode(NodeList unsignedSignatureProperties) {
        for (int i = unsignedSignatureProperties.getLength() - 1; i >= 0; --i) {
            Node childNode = unsignedSignatureProperties.item(i);
            if (!XAdESEvidencerecordNamespaceElement.SEALING_EVIDENCE_RECORDS.isSameTagName(childNode.getLocalName())) continue;
            return childNode;
        }
        return null;
    }

    private List<Node> getObjects(XAdESSignature signature) {
        NodeList objects = signature.getObjects();
        if (objects != null && objects.getLength() > 0) {
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < objects.getLength(); ++i) {
                result.add(objects.item(i));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private boolean containsQualifyingProperties(Node node, XAdESPath xadesPath) {
        Node qualifyingProperties = DomUtils.getNode((Node)node, (String)xadesPath.getCurrentQualifyingPropertiesPath());
        return qualifyingProperties != null;
    }

    private List<byte[]> getManifestDataObjects(XAdESSignature signature, Reference referenceToManifest, String canonicalizationAlgorithm) throws XMLSecurityException {
        ArrayList<byte[]> dataObjectsGroup = new ArrayList<byte[]>();
        this.getManifestDataObjectsRecursively(signature, referenceToManifest, canonicalizationAlgorithm, dataObjectsGroup);
        return dataObjectsGroup;
    }

    private void getManifestDataObjectsRecursively(XAdESSignature signature, Reference referenceToManifest, String canonicalizationAlgorithm, List<byte[]> dataObjectsGroup) throws XMLSecurityException {
        for (Reference manifestReference : this.getManifestReferences(signature, referenceToManifest)) {
            byte[] bytes;
            if (!this.isResultXmlNodeSet(manifestReference, bytes = this.getReferenceBytes(manifestReference, canonicalizationAlgorithm)) || !this.isResultManifestElement(bytes)) {
                dataObjectsGroup.add(bytes);
                continue;
            }
            this.getManifestDataObjectsRecursively(signature, referenceToManifest, canonicalizationAlgorithm, dataObjectsGroup);
        }
    }

    private List<Reference> getManifestReferences(XAdESSignature signature, Reference referenceToManifest) throws XMLSecurityException {
        String uri = referenceToManifest.getURI();
        Element manifestElement = DSSXMLUtils.getManifestById(signature.getSignatureElement(), uri);
        Manifest manifest = DSSXMLUtils.initManifestWithDetachedContent(manifestElement, this.detachedContent);
        return DSSXMLUtils.extractReferences(manifest);
    }

    private boolean isResultXmlNodeSet(Reference reference, byte[] referencedBytes) throws XMLSecurityException {
        return ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference)) && DomUtils.isDOM((byte[])referencedBytes);
    }

    private boolean isResultManifestElement(byte[] referencedBytes) {
        Document document = DomUtils.buildDOM((byte[])referencedBytes);
        Element documentElement = document.getDocumentElement();
        return XMLDSigElement.MANIFEST.isSameTagName(documentElement.getLocalName()) && XMLDSigElement.MANIFEST.getURI().equals(documentElement.getNamespaceURI());
    }

    private DSSMessageDigest computeDigestValueGroupHash(List<byte[]> dataObjectsGroup) {
        List<byte[]> digestValueGroup = dataObjectsGroup.stream().map(d -> DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])d)).collect(Collectors.toList());
        if (LOG.isTraceEnabled()) {
            LOG.trace("1. Digest Value Group:");
            digestValueGroup.forEach(d -> LOG.trace(Utils.toHex((byte[])d)));
        }
        if (Utils.collectionSize(digestValueGroup) == 1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("2a. Only one data object: {}", digestValueGroup.get(0));
            }
            return new DSSMessageDigest(this.digestAlgorithm, (byte[])digestValueGroup.get(0));
        }
        digestValueGroup.sort((Comparator<byte[]>)ByteArrayComparator.getInstance());
        if (LOG.isTraceEnabled()) {
            LOG.trace("2b. Sorted Digest Value Group:");
            digestValueGroup.forEach(d -> LOG.trace(Utils.toHex((byte[])d)));
        }
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
        for (byte[] hashValue : digestValueGroup) {
            digestCalculator.update(hashValue);
        }
        DSSMessageDigest messageDigest = digestCalculator.getMessageDigest();
        if (LOG.isTraceEnabled()) {
            LOG.trace("4. Message-digest of concatenated string: {}", (Object)messageDigest.getHexValue());
        }
        return messageDigest;
    }
}

