/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sha2;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.client.http.DSSCacheFileLoader;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.tsl.sha2.DefaultTrustedListWithSha2Predicate;
import eu.europa.esig.dss.tsl.sha2.DocumentWithSha2;
import eu.europa.esig.dss.utils.Utils;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sha2FileCacheDataLoader
implements DSSCacheFileLoader {
    private static final long serialVersionUID = 3104647343425527021L;
    private static final Logger LOG = LoggerFactory.getLogger(Sha2FileCacheDataLoader.class);
    private static final long ONE_DAY_MILLIS = 86400000L;
    private DSSCacheFileLoader dataLoader;
    private Predicate<DocumentWithSha2> predicate;

    public Sha2FileCacheDataLoader() {
    }

    public Sha2FileCacheDataLoader(DSSCacheFileLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public static Sha2FileCacheDataLoader initSha2StrictDataLoader(DSSCacheFileLoader dataLoader) {
        Sha2FileCacheDataLoader sha2DataLoader = new Sha2FileCacheDataLoader(dataLoader);
        DefaultTrustedListWithSha2Predicate sha2Predicate = new DefaultTrustedListWithSha2Predicate();
        sha2Predicate.setCacheExpirationTime(-1L);
        sha2DataLoader.setPredicate(sha2Predicate);
        return sha2DataLoader;
    }

    public static Sha2FileCacheDataLoader initSha2DailyUpdateDataLoader(DSSCacheFileLoader dataLoader) {
        Sha2FileCacheDataLoader sha2DataLoader = new Sha2FileCacheDataLoader(dataLoader);
        DefaultTrustedListWithSha2Predicate sha2Predicate = new DefaultTrustedListWithSha2Predicate();
        sha2Predicate.setCacheExpirationTime(86400000L);
        sha2DataLoader.setPredicate(sha2Predicate);
        return sha2DataLoader;
    }

    public static Sha2FileCacheDataLoader initSha2CustomExpirationDataLoader(DSSCacheFileLoader dataLoader, long cacheExpirationTime) {
        Sha2FileCacheDataLoader sha2DataLoader = new Sha2FileCacheDataLoader(dataLoader);
        DefaultTrustedListWithSha2Predicate sha2Predicate = new DefaultTrustedListWithSha2Predicate();
        sha2Predicate.setCacheExpirationTime(cacheExpirationTime);
        sha2DataLoader.setPredicate(sha2Predicate);
        return sha2DataLoader;
    }

    public static Sha2FileCacheDataLoader initSha2IgnoredDataLoader(DSSCacheFileLoader dataLoader) {
        Sha2FileCacheDataLoader sha2DataLoader = new Sha2FileCacheDataLoader(dataLoader);
        DefaultTrustedListWithSha2Predicate sha2Predicate = new DefaultTrustedListWithSha2Predicate();
        sha2Predicate.setCacheExpirationTime(0L);
        sha2DataLoader.setPredicate(sha2Predicate);
        return sha2DataLoader;
    }

    public DSSCacheFileLoader getDataLoader() {
        return this.dataLoader;
    }

    public void setDataLoader(DSSCacheFileLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setPredicate(Predicate<DocumentWithSha2> predicate) {
        this.predicate = predicate;
    }

    public DSSDocument getDocument(String url) throws DSSException {
        return this.getDocument(url, false);
    }

    public DSSDocument getDocument(String url, boolean refresh) {
        Objects.requireNonNull(url, "URL cannot be null!");
        this.assertConfigurationIsValid();
        DSSDocument sha2Document = null;
        String sha2ExtractionStatus = null;
        try {
            sha2Document = this.getSha2File(url);
        }
        catch (Exception e) {
            sha2ExtractionStatus = e.getMessage();
            String errorMessage = String.format("No sha2 document has been found : %s", sha2ExtractionStatus);
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            refresh = true;
        }
        DSSDocument cachedDocument = null;
        DSSDocument refreshedDocument = null;
        if (refresh) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Refresh has been requested for a document with URL '{}'", (Object)url);
            }
            refreshedDocument = this.getRefreshedDocument(url);
        } else {
            cachedDocument = this.getDocumentFromCache(url);
            if (cachedDocument == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No cached document found for URL '{}'", (Object)url);
                }
                refreshedDocument = this.getRefreshedDocument(url);
            }
        }
        DocumentWithSha2 documentWithSha2 = null;
        if (cachedDocument != null) {
            documentWithSha2 = this.mergeDocumentWithSha2(cachedDocument, sha2Document);
            if (this.checkRefreshRequired(documentWithSha2)) {
                LOG.info("Refresh the document from URL '{}'...", (Object)url);
                refreshedDocument = this.getRefreshedDocument(url);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Sha2 document condition match. Return cached document for URL '{}'", (Object)url);
            }
        }
        if (refreshedDocument != null) {
            documentWithSha2 = this.mergeDocumentWithSha2(refreshedDocument, sha2Document);
            this.checkRefreshRequired(documentWithSha2);
        }
        if (documentWithSha2 != null && Utils.isStringNotEmpty((String)sha2ExtractionStatus)) {
            documentWithSha2.addErrorMessage(sha2ExtractionStatus);
        }
        return documentWithSha2;
    }

    protected DSSDocument getRefreshedDocument(String documentUrl) {
        return this.dataLoader.getDocument(documentUrl, true);
    }

    protected DSSDocument getSha2File(String documentUrl) {
        String sha2FileUrl = this.getSha2FileUrl(documentUrl);
        return this.dataLoader.getDocument(sha2FileUrl, true);
    }

    protected String getSha2FileUrl(String documentUrl) {
        String fileExtension = Utils.getFileNameExtension((String)documentUrl);
        if (fileExtension != null && !fileExtension.isEmpty() && documentUrl.length() > fileExtension.length()) {
            fileExtension = documentUrl.substring(documentUrl.length() - 1 - fileExtension.length());
            documentUrl = documentUrl.substring(0, documentUrl.length() - fileExtension.length());
        }
        this.assertExtensionIsSupported(fileExtension);
        return documentUrl + ".sha2";
    }

    protected void assertExtensionIsSupported(String fileExtension) {
        if (!".xml".equals(fileExtension) && !".xtsl".equals(fileExtension)) {
            throw new DSSExternalResourceException(String.format("The Trusted List extension '%s' is not supported! Shall be one of '.xml' or '.xtsl'.", fileExtension));
        }
    }

    protected DocumentWithSha2 mergeDocumentWithSha2(DSSDocument cachedDocument, DSSDocument sha2Document) {
        return new DocumentWithSha2(cachedDocument, sha2Document);
    }

    protected boolean checkRefreshRequired(DocumentWithSha2 documentWithSha2) {
        return !this.predicate.test(documentWithSha2);
    }

    public DSSDocument getDocumentFromCache(String url) {
        this.assertConfigurationIsValid();
        try {
            return this.dataLoader.getDocumentFromCache(url);
        }
        catch (Exception e) {
            String errorMessage = "An error occurred on cached document extraction from URL '{}' : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, new Object[]{url, e.getMessage(), e});
            } else {
                LOG.warn(errorMessage, (Object)url, (Object)e.getMessage());
            }
            return null;
        }
    }

    public boolean remove(String url) {
        this.assertConfigurationIsValid();
        return this.dataLoader.remove(url);
    }

    protected void assertConfigurationIsValid() {
        Objects.requireNonNull(this.dataLoader, "DSSCacheFileLoader shall be provided!");
        Objects.requireNonNull(this.predicate, "Predicate shall be provided!");
    }
}

