/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.access;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.DownloadCache;
import eu.europa.esig.dss.tsl.cache.ParsingCache;
import eu.europa.esig.dss.tsl.cache.ValidationCache;
import eu.europa.esig.dss.tsl.dto.DownloadCacheDTO;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;
import eu.europa.esig.dss.tsl.dto.builder.DownloadCacheDTOBuilder;
import eu.europa.esig.dss.tsl.dto.builder.ParsingCacheDTOBuilder;
import eu.europa.esig.dss.tsl.dto.builder.ValidationCacheDTOBuilder;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyCacheAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyCacheAccess.class);
    protected final DownloadCache downloadCache;
    protected final ParsingCache parsingCache;
    protected final ValidationCache validationCache;

    public ReadOnlyCacheAccess(DownloadCache fileCache, ParsingCache parsingCache, ValidationCache validationCache) {
        this.downloadCache = fileCache;
        this.parsingCache = parsingCache;
        this.validationCache = validationCache;
    }

    public DownloadCacheDTO getDownloadCacheDTO(CacheKey key) {
        LOG.trace("Extracting a download cache for an entry with the key [{}]", (Object)key);
        return new DownloadCacheDTOBuilder(this.downloadCache.get(key)).build();
    }

    public ParsingCacheDTO getParsingCacheDTO(CacheKey key) {
        LOG.trace("Extracting a parsing cache for an entry with the key [{}]", (Object)key);
        return new ParsingCacheDTOBuilder(this.parsingCache.get(key)).build();
    }

    public ValidationCacheDTO getValidationCacheDTO(CacheKey key) {
        LOG.trace("Extracting a validation cache for an entry with the key [{}]", (Object)key);
        return new ValidationCacheDTOBuilder(this.validationCache.get(key)).build();
    }

    public Set<CacheKey> getAllCacheKeys() {
        HashSet<CacheKey> keys = new HashSet<CacheKey>();
        keys.addAll(this.downloadCache.getKeys());
        keys.addAll(this.parsingCache.getKeys());
        keys.addAll(this.validationCache.getKeys());
        return keys;
    }
}

