/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache;

import eu.europa.esig.dss.spi.client.http.DSSCacheFileLoader;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(CacheCleaner.class);
    private boolean cleanMemory = true;
    private boolean cleanFileSystem = false;
    private DSSCacheFileLoader dssFileLoader;

    public void setCleanMemory(boolean cleanMemory) {
        this.cleanMemory = cleanMemory;
    }

    public void setCleanFileSystem(boolean cleanFileSystem) {
        this.cleanFileSystem = cleanFileSystem;
    }

    public void setDSSFileLoader(DSSCacheFileLoader dssFileLoader) {
        this.dssFileLoader = dssFileLoader;
    }

    public void clean(CacheAccessByKey cacheAccess) {
        LOG.trace("Starting the clean operation for the entry with the key [{}]", (Object)cacheAccess.getCacheKey());
        boolean fileNeedToBeDeleted = cacheAccess.isFileNeedToBeDeleted();
        if (this.cleanMemory) {
            LOG.trace("cleanMemory is running for the entry with the key [{}]", (Object)cacheAccess.getCacheKey());
            cacheAccess.deleteDownloadCacheIfNeeded();
            cacheAccess.deleteParsingCacheIfNeeded();
            cacheAccess.deleteValidationCacheIfNeeded();
        }
        if (this.cleanFileSystem) {
            Objects.requireNonNull(this.dssFileLoader, "Cannot remove files from the file system. The DSSFileLoader must be defined!");
            if (fileNeedToBeDeleted) {
                LOG.trace("cleanFileSystem is running for the entry with the key [{}]", (Object)cacheAccess.getCacheKey());
                try {
                    boolean removed = this.dssFileLoader.remove(cacheAccess.getCacheKey().getKey());
                    if (removed) {
                        LOG.info("The file with cacheKey [{}] has been successfully removed from the file system", (Object)cacheAccess.getCacheKey());
                    } else {
                        LOG.warn("The file with cacheKey [{}] was not removed from the file system", (Object)cacheAccess.getCacheKey());
                    }
                }
                catch (Exception e) {
                    LOG.warn("An error occurred on removing of file with cacheKey [{}] from file system. Reason : {}", (Object)cacheAccess.getCacheKey(), (Object)e.getMessage());
                }
            }
        }
    }
}

