/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.XadesSignature;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.TimestampParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import com.anf.cryptotoken.sign.xades.params.XadesParams;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class XadesSignatureImpl
extends AbstractSignature
implements XadesSignature {
    public XadesSignatureImpl() {
    }

    public XadesSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public void sign(XadesParams params, File src, File dest) {
        XAdESService service = new XAdESService((CertificateVerifier)this.commonCertificateVerifier);
        this.sign(service, params, src, dest);
    }

    @Override
    public void sign(XadesParams params, InputStream input, OutputStream output) {
        try {
            XAdESService service = new XAdESService((CertificateVerifier)this.commonCertificateVerifier);
            InMemoryDocument src = new InMemoryDocument(input);
            this.sign(service, params, (DSSDocument)src, output);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    protected void sign(XAdESService service, XadesParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            FileDocument toBeSigned = new FileDocument(src);
            this.sign(service, params, (DSSDocument)toBeSigned, out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void extend(XadesParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            XAdESService service = new XAdESService((CertificateVerifier)this.commonCertificateVerifier);
            service.setTspSource(params.getTspSource());
            DSSDocument extendDocument = service.extendDocument((DSSDocument)new FileDocument(src), params.getParameters());
            try (InputStream in = extendDocument.openStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    protected void sign(XAdESService service, XadesParams params, DSSDocument src, OutputStream out) throws IOException {
        CertificateParams certificateParams = params.getCertificateParams();
        SignatureToken token = certificateParams.getSignatureToken();
        DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
        XAdESSignatureParameters parameters = params.getParameters();
        service.setTspSource(params.getTspSource());
        parameters.bLevel().setSigningDate(new Date());
        this.validateSignCert(certificateParams);
        ToBeSigned dataToSign = service.getDataToSign(src, parameters);
        SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
        DSSDocument signedDocument = service.signDocument(src, parameters, signatureValue);
        try (InputStream in = signedDocument.openStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public byte[] digest(XadesParams params, File src) {
        try {
            XAdESSignatureParameters parameters = params.getParameters();
            XAdESService service = new XAdESService((CertificateVerifier)this.commonCertificateVerifier);
            service.setTspSource(params.getTspSource());
            parameters.bLevel().setSigningDate(new Date());
            FileDocument toBeSigned = new FileDocument(src);
            ToBeSigned dataToSign = service.getDataToSign((DSSDocument)toBeSigned, parameters);
            return dataToSign.getBytes();
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void sign(XadesParams params, byte[] signature, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            XAdESService service = new XAdESService((CertificateVerifier)this.commonCertificateVerifier);
            FileDocument toBeSigned = new FileDocument(src);
            DSSDocument signedDocument = service.signDocument((DSSDocument)toBeSigned, params.getParameters(), new SignatureValue(params.getParameters().getSignatureAlgorithm(), signature));
            try (InputStream in = signedDocument.openStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    @Override
    public void timestamp(TimestampParams params, File src, File dest) {
        throw new UnsupportedOperationException("timestamp not supported on Xades");
    }
}

