/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades;

import com.anf.cryptotoken.sign.xades.XMLDSigLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.SignatureProfile;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.Objects;

public class XMLDSigService
extends XAdESService {
    private static final long serialVersionUID = 1L;

    public XMLDSigService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, XAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid((AbstractSignatureParameters)parameters);
        XMLDSigLevel xmldSigLevel = new XMLDSigLevel(this.certificateVerifier);
        byte[] dataToSign = xmldSigLevel.getDataToSign(toSignDocument, parameters);
        parameters.getContext().setProfile((SignatureProfile)xmldSigLevel);
        return new ToBeSigned(dataToSign);
    }
}

