/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.xades;

import com.anf.cryptotoken.sign.xades.XMLDSigEnvelopedSignatureBuilder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.SignatureProfile;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;

public class XMLDSigLevel
implements SignatureProfile {
    private CertificateVerifier certificateVerifier;

    public XMLDSigLevel(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public byte[] getDataToSign(DSSDocument dssDocument, XAdESSignatureParameters parameters) throws DSSException {
        XMLDSigEnvelopedSignatureBuilder signatureBuilder = new XMLDSigEnvelopedSignatureBuilder(parameters, dssDocument, this.certificateVerifier);
        parameters.getContext().setBuilder((SignatureBuilder)signatureBuilder);
        byte[] dataToSign = signatureBuilder.build();
        return dataToSign;
    }

    public DSSDocument signDocument(DSSDocument document, XAdESSignatureParameters parameters, byte[] signatureValue) throws DSSException {
        Object builder = parameters.getContext().getBuilder();
        builder = builder != null ? parameters.getContext().getBuilder() : new XMLDSigEnvelopedSignatureBuilder(parameters, document, this.certificateVerifier);
        DSSDocument dssDocument = builder.signDocument(signatureValue);
        parameters.getContext().setBuilder(builder);
        return dssDocument;
    }

    static {
        SantuarioInitializer.init();
    }
}

