/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.utils;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfCreator {
    private static final Logger log = LogManager.getLogger(PdfCreator.class);

    private PdfCreator() {
    }

    public static int createPdf(String[] files, String destPdf) {
        ArrayList<File> pdfs = new ArrayList<File>();
        ArrayList<File> imgs = new ArrayList<File>();
        for (String file : files) {
            String mimetype;
            File fi = new File(file);
            if (!fi.exists() || (mimetype = new MimetypesFileTypeMap().getContentType(fi)) == null) continue;
            String fname = fi.getName().toLowerCase();
            if (mimetype.contains("pdf") && fname.endsWith(".pdf")) {
                pdfs.add(fi);
                continue;
            }
            if (!mimetype.contains("image") && !fname.endsWith(".jpg") && !fname.endsWith(".png")) continue;
            imgs.add(fi);
        }
        return PdfCreator.createPdf(pdfs, imgs, destPdf);
    }

    public static int createLongPdf(String imgPath, String pdfPath, int pages) {
        int n;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.getParentFile().exists()) {
            pdfFile.getParentFile().mkdirs();
        }
        PDDocument document = new PDDocument();
        try {
            int c = 0;
            File imgFile = new File(imgPath);
            while (pages-- > 0) {
                c = PdfCreator.appendImage(document, c, imgFile);
            }
            document.save(pdfFile);
            n = c;
        }
        catch (Throwable throwable) {
            try {
                try {
                    document.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                System.err.println("Error creating long PDF: " + e.getMessage());
                return -1;
            }
        }
        document.close();
        return n;
    }

    private static int createPdf(List<File> pdfs, List<File> imgs, String destPdf) {
        int n;
        PDDocument document = new PDDocument();
        try {
            int c = 0;
            for (File pdfi : pdfs) {
                c = PdfCreator.appendPdf(document, c, pdfi);
            }
            for (File imgi : imgs) {
                c = PdfCreator.appendImage(document, c, imgi);
            }
            document.save(destPdf);
            n = c;
        }
        catch (Throwable throwable) {
            try {
                try {
                    document.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error creating PDF", (Throwable)e);
                return -1;
            }
        }
        document.close();
        return n;
    }

    private static int appendImage(PDDocument doc, int c, File imgFile) {
        try {
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            PDImageXObject image = PDImageXObject.createFromFile((String)imgFile.getCanonicalPath(), (PDDocument)doc);
            try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
                float scale = Math.min(page.getMediaBox().getWidth() / (float)image.getWidth(), page.getMediaBox().getHeight() / (float)image.getHeight());
                float imgWidth = (float)image.getWidth() * scale;
                float imgHeight = (float)image.getHeight() * scale;
                float x = (page.getMediaBox().getWidth() - imgWidth) / 2.0f;
                float y = (page.getMediaBox().getHeight() - imgHeight) / 2.0f;
                contentStream.drawImage(image, x, y, imgWidth, imgHeight);
            }
            ++c;
        }
        catch (Exception e) {
            System.err.println("Error appending image: " + e.getMessage());
        }
        return c;
    }

    private static int appendPdf(PDDocument targetDoc, int c, File pdfFile) {
        try (PDDocument srcDoc = Loader.loadPDF((File)pdfFile);){
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.appendDocument(targetDoc, srcDoc);
            ++c;
        }
        catch (Exception e) {
            System.err.println("Error appending PDF: " + e.getMessage());
        }
        return c;
    }
}

