/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.token.impl;

import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.device.CertificateInfo;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.token.impl.SignatureTokenSerialAlias;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.security.Signature;
import java.util.List;

public class SignatureTokenCertInfo
extends SignatureTokenSerialAlias {
    private static final Logger log = Logger.getLogger(SignatureTokenCertInfo.class);

    public SignatureTokenCertInfo(CertificateInfo certInfo) {
        super((ANFSignatureToken)certInfo.getToken(), certInfo.getDeviceSerialNumber(), certInfo.getAlias());
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        log.info(new Object[]{"Signature algorithm : ", javaSignatureAlgorithm});
        try {
            byte[] signedData = this.token.signData(this.serial, this.alias, toBeSigned.getBytes(), signatureAlgorithm.getJCEId());
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signedData);
            return value;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    protected Signature getSignatureInstance(String javaSignatureAlgorithm) {
        return this.token.getSignatureInstance(this.serial, javaSignatureAlgorithm);
    }

    @Override
    public void close() {
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        throw new DSSException("ANF not implemented");
    }
}

