/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.smime;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.SMimeSignature;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.smime.params.SMimeParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.utils.FileBase64;
import com.anf.cryptotoken.sign.validation.smime.MIMEHandler;
import com.anf.cryptotoken.utils.DatosPersonales;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.jvnet.mimepull.MIMEPart;

public class SMimeSignatureImpl
extends AbstractSignature
implements SMimeSignature {
    private static final Logger log = Logger.getLogger(SMimeSignatureImpl.class);
    private SMimeParams params;

    public SMimeSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    public SMimeSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public SMimeSignatureImpl() {
    }

    public void sign(SMimeParams params, File src, File dest) {
        this.params = params;
        File contentFile = null;
        try (MIMEHandler handler = new MIMEHandler(src);
             FileOutputStream out = new FileOutputStream(dest);){
            String originalName = src.getName();
            contentFile = this.createContentFile(handler, originalName);
            if (contentFile != null) {
                src = contentFile;
            }
            CAdESService service = new CAdESService((CertificateVerifier)this.commonCertificateVerifier);
            FileDocument toBeSigned = new FileDocument(src);
            CAdESSignatureParameters parameters = params.getParameters();
            service.setTspSource(params.getTspSource());
            parameters.bLevel().setSigningDate(new Date());
            ToBeSigned dataToSign = service.getDataToSign((DSSDocument)toBeSigned, parameters);
            CertificateParams certificateParams = params.getCertificateParams();
            SignatureToken token = certificateParams.getSignatureToken();
            DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
            SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
            DSSDocument signedDocument = service.signDocument((DSSDocument)toBeSigned, parameters, signatureValue);
            CMSSignedData signedData = ((CMSSignedDocument)signedDocument).getCMSSignedData();
            this.saveCMSSignedData(src, out, signedData);
        }
        catch (Throwable e) {
            throw new ANFSignatureException(e);
        }
        finally {
            if (contentFile != null) {
                contentFile.delete();
                contentFile.getParentFile().delete();
            }
        }
    }

    public byte[] digest(SMimeParams params, File src) {
        throw new UnsupportedOperationException("digest not supported");
    }

    public void sign(SMimeParams params, byte[] signature, File src, File dest) {
        throw new UnsupportedOperationException("signature build not supported");
    }

    private File createContentFile(MIMEHandler handler, String originalName) throws IOException {
        File contentFile = handler.getContentFile();
        List signatures = handler.getSignatures();
        if (signatures != null && signatures.size() > 0) {
            if (contentFile != null && !this.exportContentToFile(handler.getContentStream(), contentFile, originalName)) {
                throw new IOException("error copiando el contenido del archivo");
            }
        } else if (contentFile == null) {
            contentFile = new File(Files.anf(), "" + System.nanoTime());
            contentFile.mkdirs();
            contentFile = new File(contentFile, originalName);
            try (FileOutputStream outContent = new FileOutputStream(contentFile);){
                FileBase64.encodeStreamBase64(handler.getContentStream(), outContent);
            }
        }
        return contentFile;
    }

    protected void saveCMSSignedData(File src, FileOutputStream out, CMSSignedData signedData) throws Throwable {
        File temporalFirma = new File(Files.anf(), System.nanoTime() + "-smime.p7s");
        try (MIMEHandler handler = new MIMEHandler(src);){
            temporalFirma.createNewFile();
            FileOutputStream fos = new FileOutputStream(temporalFirma);
            fos.write(signedData.getEncoded());
            fos.close();
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart documento = new MimeBodyPart();
            File contentFile = handler.getContentFile();
            if (contentFile == null) {
                contentFile = src;
            }
            documento.attachFile(contentFile);
            mp.addBodyPart((BodyPart)documento);
            List signatures = handler.getSignatures();
            if (signatures != null) {
                for (int x = 0; x < signatures.size(); ++x) {
                    MIMEPart signx = (MIMEPart)signatures.get(x);
                    MimeBodyPart part = MIMEHandler.convertToBodyPart((MIMEPart)signx);
                    mp.addBodyPart((BodyPart)part);
                }
            }
            MimeBodyPart fir = new MimeBodyPart();
            fir.attachFile(temporalFirma);
            CertificateParams certificateParams = this.params.getCertificateParams();
            SignatureToken signatureToken = certificateParams.getSignatureToken();
            String additionalInfo = this.getAdditionalInformation(null, signatureToken.getSerial(), signatureToken.getSerial(), signatureToken.getName(), this.params.getMention());
            fir.setDescription(additionalInfo);
            mp.addBodyPart((BodyPart)fir);
            MimeMessage mm = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()));
            mm.addHeader("protocol", "application/pkcs7-signature");
            mm.setContent((Multipart)mp);
            mm.writeTo((OutputStream)out);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw ex;
        }
        finally {
            temporalFirma.delete();
        }
    }

    private String getAdditionalInformation(BasicOCSPResp respuesta, String serial, String origen, String deviceType, String mention) {
        Object result = "";
        String deviceTypeParam = "";
        if (deviceType != null) {
            deviceTypeParam = deviceType;
        }
        try {
            if (respuesta != null) {
                X509CertificateHolder holder = respuesta.getCerts()[0];
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                DatosPersonales datosOCSP = new DatosPersonales(cert.getSubjectX500Principal());
                DatosPersonales datosOCSPI = new DatosPersonales(cert.getIssuerX500Principal());
                Date hora = new Date();
                String pais = datosOCSP.getC();
                String localidad = datosOCSP.getST();
                String organizacionOCSP = datosOCSPI.getO();
                String nombreComunOCSP = datosOCSP.getCN();
                String cifOCSP = datosOCSPI.getSERIALNUMBER();
                String numeroSerieOCSP = cert.getSerialNumber().toString(16).toUpperCase();
                Date inicioValidezOCSP = cert.getNotBefore();
                Date finValidezOCSP = cert.getNotAfter();
                String entidadEmisoraOCSP = datosOCSPI.getCN();
                String departamentoOCSP = datosOCSP.getOU();
                result = serial + "|" + pais + "|" + localidad + "|" + organizacionOCSP + "|" + departamentoOCSP + "|" + cifOCSP + "|" + nombreComunOCSP + "|" + entidadEmisoraOCSP + "|" + numeroSerieOCSP + "|" + dateFormat.format(inicioValidezOCSP) + "|" + dateFormat.format(finValidezOCSP) + "|" + dateFormat.format(hora) + "|" + deviceTypeParam + "|" + mention;
            } else {
                result = serial + "|" + deviceTypeParam + "|" + mention;
            }
        }
        catch (CertificateException ex) {
            log.error((Object)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean exportContentToFile(InputStream contentStream, File contentFile, String srcName) throws IOException {
        File temp = new File(contentFile.getParent(), srcName);
        try {
            try (FileOutputStream contentOut = new FileOutputStream(temp);){
                IOUtils.copy((InputStream)contentStream, (OutputStream)contentOut);
            }
            try {
                boolean bl;
                try (FileInputStream in = new FileInputStream(temp);){
                    if (!FileBase64.isEncodedStreamBase64(in)) {
                        try (FileOutputStream out = new FileOutputStream(contentFile);){
                            FileBase64.encodeStreamBase64(in, out);
                        }
                        finally {
                            FileUtils.deleteQuietly((File)temp);
                        }
                    }
                    bl = true;
                }
                return bl;
            }
            finally {
                FileUtils.moveFile((File)temp, (File)contentFile);
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)temp);
            log.error((Object)e);
            return false;
        }
    }
}

