/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.params.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.commitments.ANFCommitmentType;
import com.anf.cryptotoken.sign.params.CertificateParams;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSignatureParams<P extends AbstractSignatureParameters<T>, T extends SerializableTimestampParameters> {
    private static final Logger log = Logger.getLogger(AbstractSignatureParams.class);
    protected DigestAlgorithm digestAlg;
    protected SignatureLevel level;
    protected SignaturePackaging packaging;
    protected P parameters;
    private Policy signaturePolicy;
    private CertificateParams certificateParams;
    private List<ANFCommitmentType> commitments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSignatureParams(CertificateParams certificateParams, P params) {
        this.digestAlg = params.getDigestAlgorithm();
        this.level = params.getSignatureLevel();
        this.packaging = params.getSignaturePackaging();
        this.certificateParams = certificateParams;
        P p = this.parameters = params;
        synchronized (p) {
            this.parameters.setSigningCertificate(certificateParams.getSignCert());
            this.parameters.setCertificateChain(certificateParams.getCertificates());
        }
        this.setCommitments(this.commitments);
        this.setSignaturePolicy(this.signaturePolicy);
    }

    protected AbstractSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging) {
        this(certificateParams, digestAlg, level, packaging, null);
    }

    protected AbstractSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, Policy signaturePolicy) {
        this(certificateParams, digestAlg, level, packaging, signaturePolicy, null);
    }

    protected AbstractSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, Policy signaturePolicy, List<ANFCommitmentType> commitments) {
        this.digestAlg = digestAlg;
        this.level = level;
        this.packaging = packaging;
        this.certificateParams = certificateParams;
        this.fillParameters();
        this.setCommitments(commitments);
        this.setSignaturePolicy(signaturePolicy);
    }

    public P getParameters() {
        return this.parameters;
    }

    protected abstract P createParameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillParameters() {
        double t1 = System.nanoTime();
        this.parameters = this.createParameters();
        this.parameters.setDigestAlgorithm(this.digestAlg);
        this.parameters.setReferenceDigestAlgorithm(this.digestAlg);
        this.parameters.setSignatureLevel(this.level);
        this.parameters.setSignaturePackaging(this.packaging);
        P p = this.parameters;
        synchronized (p) {
            this.parameters.setSigningCertificate(this.certificateParams.getSignCert());
            this.parameters.setCertificateChain(this.certificateParams.getCertificates());
        }
        log.info((Object)("params in " + ((double)System.nanoTime() - t1) / 1000000.0 + " ms"));
    }

    public DigestAlgorithm getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(DigestAlgorithm digestAlg) {
        this.digestAlg = digestAlg;
    }

    public SignatureLevel getLevel() {
        return this.level;
    }

    public void setLevel(SignatureLevel level) {
        this.level = level;
    }

    public SignaturePackaging getPackaging() {
        return this.packaging;
    }

    public void setPackaging(SignaturePackaging packaging) {
        this.packaging = packaging;
    }

    public TSPSource getTspSource() {
        TSPSource tspSource = null;
        switch (this.level) {
            case CAdES_BASELINE_B: 
            case PAdES_BASELINE_B: 
            case XAdES_BASELINE_B: {
                tspSource = null;
                break;
            }
            default: {
                tspSource = this.certificateParams.getTspSource();
            }
        }
        return tspSource;
    }

    public Policy getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(Policy signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
        if (signaturePolicy != null) {
            this.parameters.bLevel().setSignaturePolicy(signaturePolicy);
        }
    }

    public CertificateParams getCertificateParams() {
        return this.certificateParams;
    }

    public List<ANFCommitmentType> getCommitments() {
        return this.commitments;
    }

    public void setCommitments(List<ANFCommitmentType> commitments) {
        if (commitments != null) {
            this.commitments = commitments;
            ArrayList<ANFCommitmentType> commitmentTypes = new ArrayList<ANFCommitmentType>();
            commitmentTypes.addAll(commitments);
            this.parameters.bLevel().setCommitmentTypeIndications(commitmentTypes);
        }
    }
}

