/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.PadesAutoPosition;
import com.anf.cryptotoken.sign.pades.params.PadesSignaturePosition;
import com.anf.cryptotoken.sign.pades.params.SignPosition;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfFreeSignPositionCalculator;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfSignPositionRotator;
import com.anf.cryptotoken.sign.pades.visible.builder.PdfSignatureLocations;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class PdfPositionCalculator {
    private PdfSignatureLocations pdfSignaturesService;
    private PdfFreeSignPositionCalculator pdfFreeSignPositionCalculator;
    private PdfSignPositionRotator pdfSignPositionRotator;

    public PdfPositionCalculator(PdfSignatureLocations pdfSignaturesService, PdfFreeSignPositionCalculator pdfFreeSignPositionCalculator, PdfSignPositionRotator pdfSignPositionRotator) {
        this.pdfSignaturesService = pdfSignaturesService;
        this.pdfFreeSignPositionCalculator = pdfFreeSignPositionCalculator;
        this.pdfSignPositionRotator = pdfSignPositionRotator;
    }

    public PadesSignaturePosition calculateFreePositionInPixels(File pdf, int page, SignPosition position, String positionType, VisualSignatureRotation rotation) throws IOException {
        try (PDDocument document = Loader.loadPDF((File)pdf);){
            PadesSignaturePosition nextPos;
            List<PadesSignaturePosition> signedPositions;
            PDAcroForm acroForm;
            PadesAutoPosition autoPosition;
            PDPage pdPage = document.getPage(page - 1);
            PDRectangle pageSize = pdPage.getMediaBox();
            if (rotation != null && (rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270)) {
                pageSize = new PDRectangle(pageSize.getHeight(), pageSize.getWidth());
            }
            PadesSignaturePosition percentPosition = this.calculatePosition(position, positionType, pageSize);
            System.out.println("\n\n[[[[[[[[[[transformed position]]]]]]]]] => \n x: " + percentPosition.getX() + "\n y: " + percentPosition.getY());
            if (position.getAutoPosition() != null && (autoPosition = position.getAutoPosition()) != PadesAutoPosition.FIX && (acroForm = document.getDocumentCatalog().getAcroForm()) != null && !(signedPositions = this.pdfSignaturesService.getRectanglesOfVisibleSignaturesInPades(pageSize, acroForm.getFields(), page)).isEmpty() && (nextPos = this.pdfFreeSignPositionCalculator.getAutoPositionOfNextSignature(this.pdfSignPositionRotator.rotate(percentPosition, rotation), signedPositions, autoPosition)) != null) {
                percentPosition = this.pdfSignPositionRotator.rotateBack(nextPos, rotation);
            }
            PadesSignaturePosition pixelPos = this.toPixel(percentPosition, pageSize);
            System.out.println("\n\n[[[[[[[[[[pixelPos]]]]]]]]] => \n x: " + pixelPos.getX() + "\n y: " + pixelPos.getY() + "\n w: " + pixelPos.getWidth() + "\n h: " + pixelPos.getHeight());
            PadesSignaturePosition padesSignaturePosition = pixelPos;
            return padesSignaturePosition;
        }
    }

    public PadesSignaturePosition toPixel(PadesSignaturePosition fixedPosition, PDRectangle pageSize) {
        double pageW = pageSize.getWidth();
        double pageH = pageSize.getHeight();
        double x = fixedPosition.getX() / 100.0 * pageW;
        double y = fixedPosition.getY() / 100.0 * pageH;
        double width = fixedPosition.getWidth() / 100.0 * pageW;
        double height = fixedPosition.getHeight() / 100.0 * pageH;
        return new PadesSignaturePosition(x, y, width, height);
    }

    private PadesSignaturePosition calculatePosition(SignPosition position, String positionType, PDRectangle pageSize) {
        switch (positionType) {
            case "Percent": {
                return this.percentPosition(position);
            }
            case "Fixed": 
            case "Fixed-Percent": {
                return this.fixedPosition(position, pageSize, false);
            }
            case "Fixed-Pixels": {
                return this.fixedPosition(position, pageSize, true);
            }
        }
        return this.pixelsPosition(position, pageSize);
    }

    private PadesSignaturePosition pixelsPosition(SignPosition position, PDRectangle pageSize) {
        double xpos = PdfPositionCalculator.checkRange(position.getX(), 0.0, pageSize.getWidth(), 0.0);
        double ypos = PdfPositionCalculator.checkRange(position.getY(), 0.0, pageSize.getHeight(), 0.0);
        double width = PdfPositionCalculator.checkRange(position.getW(), 1.0, pageSize.getWidth(), 40.0);
        double heigth = PdfPositionCalculator.checkRange(position.getH(), 1.0, pageSize.getHeight(), 20.0);
        return this.percentPosition(xpos, ypos, width, heigth, pageSize.getWidth(), pageSize.getHeight());
    }

    private PadesSignaturePosition percentPosition(SignPosition position) {
        double xpos = PdfPositionCalculator.checkRange(position.getX(), 0.0, 100.0, 0.0);
        double ypos = PdfPositionCalculator.checkRange(position.getY(), 0.0, 100.0, 0.0);
        double width = PdfPositionCalculator.checkRange(position.getW(), 1.0, 100.0, 40.0);
        double heigth = PdfPositionCalculator.checkRange(position.getH(), 1.0, 100.0, 20.0);
        return this.checkedPosition(xpos, ypos, width, heigth);
    }

    private PadesSignaturePosition percentPosition(double xpos, double ypos, double width, double heigth, double pageWidth, double pageHeight) {
        xpos = xpos * 100.0 / pageWidth;
        ypos = ypos * 100.0 / pageHeight;
        width = width * 100.0 / pageWidth;
        heigth = heigth * 100.0 / pageHeight;
        return this.checkedPosition(xpos, ypos, width, heigth);
    }

    private PadesSignaturePosition checkedPosition(double xpos, double ypos, double width, double heigth) {
        xpos = Math.min(100.0, Math.max(0.0, xpos));
        ypos = Math.min(100.0, Math.max(0.0, ypos));
        width = Math.min(100.0, Math.max(1.0, width));
        heigth = Math.min(100.0, Math.max(1.0, heigth));
        return new PadesSignaturePosition(xpos, ypos, width, heigth);
    }

    private PadesSignaturePosition fixedPosition(SignPosition position, PDRectangle pageSize, boolean pixels) {
        double heigth;
        double width;
        double pageHeight;
        double pageWidth;
        double yMargin;
        String fixedValue = "TL";
        if (position.getValue() != null) {
            fixedValue = position.getValue();
        }
        double xpos = -1.0;
        double ypos = -1.0;
        double xMargin = position.getX() != null ? position.getX() : 0.0;
        double d = yMargin = position.getY() != null ? position.getY() : 0.0;
        if (pixels) {
            pageWidth = pageSize.getWidth();
            pageHeight = pageSize.getHeight();
            width = position.getW() != null ? position.getW() : 200.0;
            heigth = position.getH() != null ? position.getH() : 100.0;
        } else {
            pageWidth = 100.0;
            pageHeight = 100.0;
            width = position.getW() != null ? position.getW() : 40.0;
            heigth = position.getH() != null ? position.getH() : 20.0;
        }
        switch (fixedValue.charAt(0)) {
            case 'M': {
                ypos = pageHeight * 0.5;
                heigth = Math.max(1.0, Math.min(heigth, pageHeight * 0.5 - yMargin));
                break;
            }
            case 'B': {
                heigth = Math.min(heigth, pageHeight - yMargin);
                ypos = Math.max(0.0, pageHeight - yMargin - heigth);
                break;
            }
            default: {
                ypos = yMargin;
                heigth = Math.min(heigth, pageHeight - ypos);
            }
        }
        switch (fixedValue.charAt(1)) {
            case 'M': {
                xpos = pageWidth * 0.5;
                width = Math.max(0.0, Math.min(width, pageWidth * 0.5 - xMargin));
                break;
            }
            case 'R': {
                width = Math.min(width, pageWidth - xMargin);
                xpos = Math.max(0.0, pageWidth - xMargin - width);
                break;
            }
            default: {
                xpos = xMargin;
                width = Math.min(width, pageWidth - xpos);
            }
        }
        return this.percentPosition(xpos, ypos, width, heigth, pageWidth, pageHeight);
    }

    public static double checkRange(Double value, double min, double max, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value < min || value > max) {
            return defaultValue;
        }
        return value;
    }
}

