/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible.builder;

import com.anf.cryptotoken.sign.pades.params.PadesAutoPosition;
import com.anf.cryptotoken.sign.pades.params.PadesSignaturePosition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PdfFreeSignPositionCalculator {
    private static final Logger log = LogManager.getLogger(PdfFreeSignPositionCalculator.class);

    public PadesSignaturePosition getAutoPositionOfNextSignature(PadesSignaturePosition toBeProcess, List<PadesSignaturePosition> signedPositions, PadesAutoPosition autoPosition) {
        if (autoPosition == PadesAutoPosition.FIX) {
            return toBeProcess;
        }
        List<PadesSignaturePosition> collisions = this.checkCollisions(toBeProcess, signedPositions);
        if (collisions.isEmpty()) {
            return toBeProcess;
        }
        ArrayList<? super PadesSignaturePosition> candidates = new ArrayList<PadesSignaturePosition>();
        for (PadesSignaturePosition pos : signedPositions) {
            PadesSignaturePosition newPos = this.move(toBeProcess, pos, autoPosition);
            if (newPos == null || !this.checkCollisions(newPos, signedPositions).isEmpty() || !newPos.isInsideAPage()) continue;
            candidates.add(newPos);
        }
        if (!candidates.isEmpty()) {
            if (candidates.size() == 1) {
                return (PadesSignaturePosition)candidates.get(0);
            }
            candidates.sort(this.bestPositionComparator(autoPosition));
            return (PadesSignaturePosition)candidates.get(0);
        }
        return toBeProcess;
    }

    private Comparator<? super PadesSignaturePosition> bestPositionComparator(PadesAutoPosition autoPosition) {
        return (pos1, pos2) -> {
            switch (autoPosition) {
                case BELOW: {
                    return pos1.getY() + pos1.getHeight() >= pos2.getY() ? 1 : -1;
                }
                case ABOVE: {
                    return pos1.getY() - pos2.getHeight() <= pos2.getY() ? 1 : -1;
                }
                case RIGHTSIDE: {
                    return pos1.getX() + pos1.getWidth() >= pos2.getX() ? 1 : -1;
                }
                case LEFTSIDE: {
                    return pos1.getX() - pos2.getWidth() <= pos2.getX() ? 1 : -1;
                }
            }
            return 0;
        };
    }

    private PadesSignaturePosition move(PadesSignaturePosition toBeProcess, PadesSignaturePosition pos, PadesAutoPosition autoPosition) {
        switch (autoPosition) {
            case BELOW: {
                if (pos.getY() + pos.getHeight() >= toBeProcess.getY()) {
                    return new PadesSignaturePosition(toBeProcess.getX(), pos.getY() + pos.getHeight(), toBeProcess.getWidth(), toBeProcess.getHeight());
                }
                return null;
            }
            case ABOVE: {
                if (pos.getY() - toBeProcess.getHeight() <= toBeProcess.getY()) {
                    return new PadesSignaturePosition(toBeProcess.getX(), pos.getY() - toBeProcess.getHeight(), toBeProcess.getWidth(), toBeProcess.getHeight());
                }
                return null;
            }
            case RIGHTSIDE: {
                if (pos.getX() + pos.getWidth() >= toBeProcess.getX()) {
                    return new PadesSignaturePosition(pos.getX() + pos.getWidth(), toBeProcess.getY(), toBeProcess.getWidth(), toBeProcess.getHeight());
                }
                return null;
            }
            case LEFTSIDE: {
                if (pos.getX() - toBeProcess.getWidth() <= toBeProcess.getX()) {
                    return new PadesSignaturePosition(pos.getX() - toBeProcess.getWidth(), toBeProcess.getY(), toBeProcess.getWidth(), toBeProcess.getHeight());
                }
                return null;
            }
        }
        return toBeProcess;
    }

    private List<PadesSignaturePosition> checkCollisions(PadesSignaturePosition toBeProcess, List<PadesSignaturePosition> signedPositions) {
        LinkedList<PadesSignaturePosition> collisions = new LinkedList<PadesSignaturePosition>();
        for (PadesSignaturePosition pos : signedPositions) {
            log.debug("\n[[[[[[[[[[pos]]]]]]]]] => \n x: " + pos.getX() + "\n y: " + pos.getY() + "\n w: " + pos.getWidth() + "\n h: " + pos.getHeight());
            if (!pos.hasCollisionWith(toBeProcess)) continue;
            collisions.add(pos);
        }
        return collisions;
    }
}

