/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringDrawerUtils {
    public static List<String> wrap(String str, FontMetrics fm, int maxWidth) {
        List<String> lines = StringDrawerUtils.splitIntoLines(str);
        if (lines.size() == 0) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            StringDrawerUtils.wrapLineInto(iter.next(), strings, fm, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, FontMetrics fm, int maxWidth) {
        int width;
        int len = line.length();
        while (len > 0 && (width = fm.stringWidth(line)) > maxWidth) {
            int pos;
            int guess = len * maxWidth / width;
            String before = line.substring(0, guess).trim();
            if ((width = fm.stringWidth(before)) > maxWidth) {
                pos = StringDrawerUtils.findBreakBefore(line, guess);
            } else {
                pos = StringDrawerUtils.findBreakAfter(line, guess);
                if (pos != -1 && fm.stringWidth(before = line.substring(0, pos).trim()) > maxWidth) {
                    pos = StringDrawerUtils.findBreakBefore(line, guess);
                }
            }
            if (pos == -1) {
                pos = guess;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static int findBreakBefore(String line, int start) {
        for (int i = start; i >= 0; --i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static int findBreakAfter(String line, int start) {
        int len = line.length();
        for (int i = start; i < len; ++i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int len = str.length();
        if (len == 0) {
            strings.add("");
            return strings;
        }
        int lineStart = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\r') {
                int newlineLength = 1;
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    newlineLength = 2;
                }
                strings.add(str.substring(lineStart, i));
                lineStart = i + newlineLength;
                if (newlineLength != 2) continue;
                ++i;
                continue;
            }
            if (c != '\n') continue;
            strings.add(str.substring(lineStart, i));
            lineStart = i + 1;
        }
        if (lineStart < len) {
            strings.add(str.substring(lineStart));
        }
        return strings;
    }
}

