/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.sign.pades.visible.GradientExtensionHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGLoader {
    private static SVGLoader instance;
    private SAXSVGDocumentFactory factory;
    private BridgeContext ctx;
    private GVTBuilder builder;

    private SVGLoader() {
        this.initialize();
    }

    public GraphicsNode loadSVG(byte[] svgBytes) throws IOException {
        SVGDocument svgDocument = this.loadSVGDocument(svgBytes);
        return this.loadSVG(svgDocument);
    }

    public GraphicsNode loadSVG(SVGDocument svgDocument) {
        return this.builder.build(this.ctx, (Document)svgDocument);
    }

    public SVGDocument loadSVGDocument(byte[] svgBytes) throws IOException {
        return this.factory.createSVGDocument(null, (InputStream)new ByteArrayInputStream(svgBytes));
    }

    public GraphicsNode loadSVG(File svgFile) throws IOException {
        SVGDocument svgDocument = this.loadSVGDocument(svgFile);
        return this.loadSVG(svgDocument);
    }

    public SVGDocument loadSVGDocument(File svgFile) throws IOException, MalformedURLException {
        return this.factory.createSVGDocument(svgFile.toURI().toURL().toString());
    }

    private void initialize() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNamespaceURI = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNamespaceURI, "svg", null);
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setExtensionHandler((ExtensionHandler)new GradientExtensionHandler());
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        this.factory = new SAXSVGDocumentFactory(parser);
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        this.ctx = new BridgeContext((UserAgent)userAgent, loader);
        this.ctx.setDynamicState(2);
        this.builder = new GVTBuilder();
    }

    public static SVGLoader instance() {
        if (instance == null) {
            instance = new SVGLoader();
        }
        return instance;
    }

    public SVGDocument reloadSVGDocument(SVGDocument svgDocument) throws IOException {
        SVGGraphics2D svgGenerator = new SVGGraphics2D((Document)svgDocument);
        boolean useCSS = true;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (OutputStreamWriter fos = new OutputStreamWriter(bout);){
            svgGenerator.stream(svgDocument.getDocumentElement(), (Writer)fos, useCSS, false);
        }
        return SVGLoader.instance().loadSVGDocument(bout.toByteArray());
    }

    public void saveSVGDocument(SVGDocument svgDocument, File filePath) throws IOException {
        SVGGraphics2D svgGenerator = new SVGGraphics2D((Document)svgDocument);
        boolean useCSS = true;
        try (FileWriter fos = new FileWriter(filePath);){
            svgGenerator.stream(svgDocument.getDocumentElement(), (Writer)fos, useCSS, false);
        }
    }

    public void addTransparentPoints(SVGDocument svgDocument, SVGSVGElement rootElement, double width, double height) {
        int rectWidth = 1;
        Element transparentRectTopLeft = svgDocument.createElementNS(svgDocument.getNamespaceURI(), "rect");
        transparentRectTopLeft.setAttributeNS(null, "x", "0");
        transparentRectTopLeft.setAttributeNS(null, "y", "0");
        transparentRectTopLeft.setAttributeNS(null, "width", "" + rectWidth);
        transparentRectTopLeft.setAttributeNS(null, "height", "" + rectWidth);
        transparentRectTopLeft.setAttributeNS(null, "fill", "#000000");
        transparentRectTopLeft.setAttributeNS(null, "fill-opacity", "0.0");
        rootElement.appendChild((Node)transparentRectTopLeft);
        Element transparentRectBottomRight = svgDocument.createElementNS(svgDocument.getNamespaceURI(), "rect");
        transparentRectBottomRight.setAttributeNS(null, "x", String.valueOf(width - (double)rectWidth));
        transparentRectBottomRight.setAttributeNS(null, "y", String.valueOf(height - (double)rectWidth));
        transparentRectBottomRight.setAttributeNS(null, "width", "" + rectWidth);
        transparentRectBottomRight.setAttributeNS(null, "height", "" + rectWidth);
        transparentRectBottomRight.setAttributeNS(null, "fill", "#000000");
        transparentRectBottomRight.setAttributeNS(null, "fill-opacity", "0.0");
        rootElement.appendChild((Node)transparentRectBottomRight);
    }
}

