/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.visible;

import com.anf.cryptotoken.sign.pades.params.ImageRectangle;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultImageDrawerUtils;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

public class ImageMergeTool {
    private Color background;
    private Color imageBoxBorderColor;
    private Color horizontalLinesColor;
    private Color verticalLinesColor;

    public BufferedImage mergeImageBoxes(VisualSignatureRotation rotation, SignatureFieldDimensionAndPosition rectangle, List<ImageRectangle> imageBoxes, int dpi) throws IOException {
        int width = (int)DPIUtils.computeProperSize((float)rectangle.getBoxWidth(), (float)dpi);
        int height = (int)DPIUtils.computeProperSize((float)rectangle.getBoxHeight(), (float)dpi);
        if (rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270) {
            height = (int)DPIUtils.computeProperSize((float)rectangle.getBoxWidth(), (float)dpi);
            width = (int)DPIUtils.computeProperSize((float)rectangle.getBoxHeight(), (float)dpi);
        }
        BufferedImage imagenFinal = new BufferedImage(width, height, 2);
        Graphics2D g2d = imagenFinal.createGraphics();
        DefaultImageDrawerUtils.initRendering((Graphics2D)g2d);
        if (this.background != null) {
            g2d.setColor(this.background);
            g2d.fillRect(0, 0, imagenFinal.getWidth(), imagenFinal.getHeight());
        }
        for (ImageRectangle imageBox : imageBoxes) {
            SignatureFieldDimensionAndPosition imageDimension = this.buildImageBox(rotation, rectangle, imageBox);
            Rectangle imageRect = new Rectangle((int)DPIUtils.computeProperSize((float)imageDimension.getImageX(), (float)dpi), (int)DPIUtils.computeProperSize((float)imageDimension.getImageY(), (float)dpi), (int)DPIUtils.computeProperSize((float)imageDimension.getImageWidth(), (float)dpi), (int)DPIUtils.computeProperSize((float)imageDimension.getImageHeight(), (float)dpi));
            g2d.drawImage(imageBox.getBuffImage(), (int)imageRect.getX(), (int)imageRect.getY(), (int)imageRect.getWidth(), (int)imageRect.getHeight(), null);
            if (this.imageBoxBorderColor == null) continue;
            g2d.setColor(this.imageBoxBorderColor);
            g2d.draw(imageRect);
        }
        if (this.horizontalLinesColor != null) {
            g2d.setColor(this.horizontalLinesColor);
            for (int i = 0; i < 10; ++i) {
                double y = 10.0 * ((double)i / 100.0) * (double)height;
                g2d.draw(new Line2D.Double(0.0, y, width, y));
            }
        }
        if (this.verticalLinesColor != null) {
            g2d.setColor(this.verticalLinesColor);
            for (int i = 0; i < 10; ++i) {
                double x = 10.0 * ((double)i / 100.0) * (double)width;
                g2d.draw(new Line2D.Double(x, 0.0, x, height));
            }
        }
        g2d.dispose();
        return imagenFinal;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setImageBoxBorderColor(Color imageBoxBorderColor) {
        this.imageBoxBorderColor = imageBoxBorderColor;
    }

    public void setHorizontalLinesColor(Color horizontalLinesColor) {
        this.horizontalLinesColor = horizontalLinesColor;
    }

    public void setVerticalLinesColor(Color verticalLinesColor) {
        this.verticalLinesColor = verticalLinesColor;
    }

    public SignatureFieldDimensionAndPosition buildImageBox(VisualSignatureRotation rotation, SignatureFieldDimensionAndPosition rectangle, ImageRectangle imageBox) throws IOException {
        SignatureFieldDimensionAndPosition imageBoxDimension = new SignatureFieldDimensionAndPosition();
        AnnotationBox box = rectangle.getAnnotationBox();
        System.out.println("rotation: " + rotation);
        float width = box.getWidth();
        float height = box.getHeight();
        if (rotation == null || rotation == VisualSignatureRotation.AUTOMATIC || rotation == VisualSignatureRotation.NONE || rotation == VisualSignatureRotation.ROTATE_180) {
            imageBoxDimension.setImageX((float)((double)width * (imageBox.getX() / 100.0)));
            imageBoxDimension.setImageY((float)((double)height * (imageBox.getY() / 100.0)));
            imageBoxDimension.setImageWidth((float)((double)width * (imageBox.getWidth() / 100.0)));
            imageBoxDimension.setImageHeight((float)((double)height * (imageBox.getHeight() / 100.0)));
        } else {
            imageBoxDimension.setImageY((float)((double)width * (imageBox.getY() / 100.0)));
            imageBoxDimension.setImageX((float)((double)height * (imageBox.getX() / 100.0)));
            imageBoxDimension.setImageHeight((float)((double)width * (imageBox.getHeight() / 100.0)));
            imageBoxDimension.setImageWidth((float)((double)height * (imageBox.getWidth() / 100.0)));
        }
        float rectWidth = imageBoxDimension.getImageWidth();
        float rectHeight = imageBoxDimension.getImageHeight();
        Rectangle2D dim = imageBox.imageSize();
        float imageWidth = (float)dim.getWidth();
        float imageHeight = (float)dim.getHeight();
        float xAxis = imageBoxDimension.getImageX();
        float yAxis = imageBoxDimension.getImageY();
        if (imageWidth > rectWidth) {
            imageHeight = (int)(imageHeight * (rectWidth / imageWidth));
            imageWidth = rectWidth;
        }
        if (imageHeight > rectHeight) {
            imageWidth = (int)(imageWidth * (rectHeight / imageHeight));
            imageHeight = rectHeight;
        }
        switch (imageBox.getAdjustment()) {
            case ADJUST: {
                if (rectWidth > imageWidth && rectWidth / imageWidth * imageHeight <= rectHeight) {
                    imageHeight = (int)(rectWidth / imageWidth * imageHeight);
                    imageWidth = rectWidth;
                    break;
                }
                if (!(rectHeight > imageHeight) || !(rectHeight / imageHeight * imageWidth <= rectWidth)) break;
                imageWidth = (int)(rectHeight / imageHeight * imageWidth);
                imageHeight = rectHeight;
                break;
            }
            case EXPAND: {
                imageHeight = rectHeight;
                imageWidth = rectWidth;
                break;
            }
        }
        float x = 0.0f;
        float y = 0.0f;
        if (rotation == VisualSignatureRotation.ROTATE_90 || rotation == VisualSignatureRotation.ROTATE_270) {
            width = box.getHeight();
            height = box.getWidth();
        }
        switch (imageBox.getPosition()) {
            case TOP_LEFT: {
                x = xAxis;
                y = yAxis;
                break;
            }
            case TOP: {
                x = width / 2.0f - imageWidth / 2.0f;
                y = yAxis;
                break;
            }
            case TOP_RIGHT: {
                x = width - imageWidth - xAxis;
                y = yAxis;
                break;
            }
            case CENTER_LEFT: {
                x = xAxis;
                y = height / 2.0f - imageHeight / 2.0f;
                break;
            }
            case CENTER: {
                x = width / 2.0f - imageWidth / 2.0f;
                y = height / 2.0f - imageHeight / 2.0f;
                break;
            }
            case CENTER_RIGHT: {
                x = width - imageWidth - xAxis;
                y = height / 2.0f - imageHeight / 2.0f;
                break;
            }
            case BOTTOM_LEFT: {
                x = xAxis;
                y = height - imageHeight - yAxis;
                break;
            }
            case BOTTOM: {
                x = width / 2.0f - imageWidth / 2.0f;
                y = height - imageHeight - yAxis;
                break;
            }
            case BOTTOM_RIGHT: {
                x = width - imageWidth - xAxis;
                y = height - imageHeight - yAxis;
                break;
            }
        }
        imageBoxDimension.setImageX(x);
        imageBoxDimension.setImageY(y);
        imageBoxDimension.setImageWidth(imageWidth);
        imageBoxDimension.setImageHeight(imageHeight);
        return imageBoxDimension;
    }
}

