/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.params;

public class PadesSignaturePosition {
    private double x;
    private double y;
    private double w;
    private double h;

    public PadesSignaturePosition(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.w = width;
        this.h = height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public boolean hasCollisionWith(PadesSignaturePosition pos) {
        return this.x < pos.x + pos.getWidth() && this.x + this.w > pos.x && this.y < pos.y + pos.getHeight() && this.y + this.h > pos.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setWidth(double width) {
        this.w = width;
    }

    public void setHeight(double height) {
        this.h = height;
    }

    public boolean isInsideAPage() {
        return this.x >= 0.0 && this.x + this.w <= 100.0 && this.y >= 0.0 && this.y + this.h <= 100.0;
    }

    public static void main(String[] args) {
        PadesSignaturePosition position1 = new PadesSignaturePosition(100.0, 100.0, 50.0, 50.0);
        PadesSignaturePosition position2 = new PadesSignaturePosition(50.0, 50.0, 51.0, 51.0);
        System.out.println("" + position1.hasCollisionWith(position2));
        System.out.println("" + position2.hasCollisionWith(position1));
    }
}

