/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades.params;

import com.anf.cryptotoken.sign.commitments.ANFCommitmentType;
import com.anf.cryptotoken.sign.pades.params.PadesParams;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.pades.visible.PadesText;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.params.impl.AbstractSignatureParams;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class PadesSignatureParams
extends AbstractSignatureParams<PAdESSignatureParameters, CAdESTimestampParameters>
implements PadesParams {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private VisibleSignatureParams visibleParams;
    private PadesText padesText;

    public PadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, String reason, String location, Policy signaturePolicy, VisibleSignatureParams visibleParams) {
        super(certificateParams, digestAlg, level, packaging, signaturePolicy);
        this.visibleParams = visibleParams;
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (visibleParams != null) {
            this.getParameters().setImageParameters(visibleParams.getImageParameters());
        }
        if (signaturePolicy == null) {
            this.getParameters().setReason(reason);
        }
        this.getParameters().setLocation(location);
        this.padesText = new PadesText();
    }

    public PadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, String reason, String location, VisibleSignatureParams visibleParams) {
        this(certificateParams, digestAlg, level, packaging, reason, location, null, visibleParams);
    }

    public PadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, String reason, String location, Policy signaturePolicy) {
        this(certificateParams, digestAlg, level, packaging, reason, location, signaturePolicy, null);
    }

    public PadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging, String reason, String location) {
        this(certificateParams, digestAlg, level, packaging, reason, location, null, null);
    }

    public PadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, SignaturePackaging packaging) {
        this(certificateParams, digestAlg, level, packaging, null, null, null, null);
    }

    @Override
    protected PAdESSignatureParameters createParameters() {
        PAdESSignatureParameters pAdESSignatureParameters = new PAdESSignatureParameters();
        int defaultSignatureSize = 18944;
        pAdESSignatureParameters.setContentSize(defaultSignatureSize);
        PAdESTimestampParameters timestampParameters = new PAdESTimestampParameters(this.digestAlg);
        timestampParameters.setContentSize(defaultSignatureSize);
        pAdESSignatureParameters.setArchiveTimestampParameters((CAdESTimestampParameters)timestampParameters);
        pAdESSignatureParameters.setContentTimestampParameters((CAdESTimestampParameters)timestampParameters);
        pAdESSignatureParameters.setSignatureTimestampParameters((CAdESTimestampParameters)timestampParameters);
        return pAdESSignatureParameters;
    }

    @Override
    public PAdESSignatureParameters getParameters() {
        return (PAdESSignatureParameters)this.parameters;
    }

    @Override
    public VisibleSignatureParams getVisibleParams() {
        return this.visibleParams;
    }

    @Override
    public void setVisibleParams(VisibleSignatureParams visibleParams) {
        this.visibleParams = visibleParams;
    }

    @Override
    public void setStandardVisibleText(Date signDate, X509Certificate signCert) {
        Object text = "";
        try {
            X500Name x500name = new JcaX509CertificateHolder(signCert).getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            text = (String)text + this.padesText.getText("signed.by", "Digitally signed by") + ": " + IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue()) + "\n";
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        text = (String)text + this.padesText.getText("date", "Date") + ": " + this.formatter.format(signDate) + " GMT\n";
        if (this.getParameters().getReason() != null) {
            text = (String)text + this.padesText.getText("reason", "Reason") + ": " + this.getParameters().getReason() + "\n";
        }
        if (this.getParameters().getLocation() != null) {
            text = (String)text + this.padesText.getText("location", "Location") + ": " + this.getParameters().getLocation() + "\n";
        }
        this.visibleParams.setText((String)text);
    }

    @Override
    public String getReason() {
        return this.getParameters().getReason();
    }

    @Override
    public String getLocation() {
        return this.getParameters().getLocation();
    }

    @Override
    public PadesText getPadesText() {
        return this.padesText;
    }

    @Override
    public void setSignaturePolicy(Policy signaturePolicy) {
        super.setSignaturePolicy(signaturePolicy);
        if (signaturePolicy != null) {
            this.getParameters().setReason(null);
        }
    }

    @Override
    public void setCommitments(List<ANFCommitmentType> commitments) {
        super.setCommitments(commitments);
        if (commitments != null && !commitments.isEmpty()) {
            this.getParameters().setReason(null);
        }
    }
}

