/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.PadesSignature;
import com.anf.cryptotoken.sign.pades.PadesDataToSignService;
import com.anf.cryptotoken.sign.pades.factory.PdfBoxSignatureObjectFactory;
import com.anf.cryptotoken.sign.pades.params.PadesParams;
import com.anf.cryptotoken.sign.pades.params.PadesTimestampParams;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.pades.visible.PdfBoxCustomNativeSignatureDrawerFactory;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.pades.signature.PAdESService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawerFactory;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.PdfBoxDefaultSignatureDrawerFactory;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class PadesSignatureImpl
extends AbstractSignature
implements PadesSignature {
    private static final Logger log = LogManager.getLogger(PadesSignatureImpl.class);

    public PadesSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    public PadesSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public PadesSignatureImpl() {
    }

    public void sign(PadesParams params, File src, File dest) {
        PadesDataToSignService dataToSignService = new PadesDataToSignService(this);
        DSSDocument signedDocument = null;
        try {
            ToBeSigned dataToSign = dataToSignService.build(params, src);
            signedDocument = this.sign(params, dataToSignService.toBeSigned, dataToSignService.service, dataToSign);
            this.write(signedDocument, dest);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
        finally {
            dataToSignService.clear();
        }
    }

    public void extend(PadesParams params, File src, File dest) {
        PadesDataToSignService dataToSignService = new PadesDataToSignService(this);
        try {
            PAdESSignatureParameters parameters = dataToSignService.configure(params);
            DSSDocument extendedDocument = dataToSignService.service.extendDocument((DSSDocument)new FileDocument(src), parameters);
            this.write(extendedDocument, dest);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
        finally {
            dataToSignService.clear();
        }
    }

    private void write(DSSDocument signedDocument, File dest) throws IOException {
        try (InputStream in = signedDocument.openStream();
             FileOutputStream out = new FileOutputStream(dest);){
            Utils.copy((InputStream)in, (OutputStream)out);
        }
        if (signedDocument instanceof FileDocument) {
            FileDocument doc = (FileDocument)signedDocument;
            boolean moved = FileUtils.deleteQuietly((File)doc.getFile());
            log.debug("delete temp file {} {}", (Object)doc.getFile(), (Object)moved);
        }
    }

    @Override
    public void sign(PadesParams params, byte[] dataToSign, byte[] signature, File computed, File dest) {
        PadesDataToSignService dataToSignService = new PadesDataToSignService(this);
        dataToSignService.setValidateSignCert(false);
        try {
            params.setVisibleParams(null);
            PAdESSignatureParameters parameters = dataToSignService.configure(params, computed);
            byte[] digest = this.getDigest(dataToSign);
            ((PAdESSignatureParameters)params.getParameters()).getContext().getPdfToBeSignedCache().setMessageDigest(new DSSMessageDigest(params.getDigestAlg(), digest));
            ((PAdESSignatureParameters)params.getParameters()).getContext().getPdfToBeSignedCache().setToBeSignedDocument(dataToSignService.toBeSigned);
            DSSDocument signedDocument = dataToSignService.service.signDocument(dataToSignService.toBeSigned, parameters, new SignatureValue(parameters.getSignatureAlgorithm(), signature));
            this.write(signedDocument, dest);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
        finally {
            dataToSignService.clear();
        }
    }

    private byte[] getDigest(byte[] dataToSign) throws DigestException {
        ASN1Set set = ASN1Set.getInstance((Object)dataToSign);
        for (int i = 0; i < set.size(); ++i) {
            ASN1Set hashSet;
            ASN1ObjectIdentifier oid;
            ASN1Encodable aSN1Encodable;
            ASN1Sequence seq;
            ASN1Encodable obj = set.getObjectAt(i);
            if (!(obj instanceof ASN1Sequence) || (seq = (ASN1Sequence)obj).size() < 2 || !((aSN1Encodable = seq.getObjectAt(0)) instanceof ASN1ObjectIdentifier) || !(oid = (ASN1ObjectIdentifier)aSN1Encodable).equals((ASN1Primitive)CMSAttributes.messageDigest) || !((aSN1Encodable = seq.getObjectAt(1)) instanceof ASN1Set) || (hashSet = (ASN1Set)aSN1Encodable).size() < 1 || !((aSN1Encodable = hashSet.getObjectAt(0)) instanceof ASN1OctetString)) continue;
            ASN1OctetString hashString = (ASN1OctetString)aSN1Encodable;
            return hashString.getOctets();
        }
        throw new DigestException("ERR_GET DIGEST");
    }

    public void sign(PadesParams params, byte[] signature, File src, File dest) {
        throw new UnsupportedOperationException("pades signature requires dataToSign");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSSDocument sign(PadesParams params, DSSDocument toBeSigned, PAdESService service, ToBeSigned dataToSign) {
        CertificateParams certificateParams = params.getCertificateParams();
        SignatureToken token = certificateParams.getSignatureToken();
        double t1 = System.nanoTime();
        DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
        PAdESSignatureParameters parameters = (PAdESSignatureParameters)params.getParameters();
        SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
        try {
            DSSDocument dSSDocument = this.signDocument(service, parameters, toBeSigned, signatureValue);
            return dSSDocument;
        }
        finally {
            log.debug("main sign in {} ms", (Object)(((double)System.nanoTime() - t1) / 1000000.0));
        }
    }

    private DSSDocument signDocument(PAdESService service, PAdESSignatureParameters parameters, DSSDocument toBeSigned, SignatureValue signatureValue) {
        try {
            return service.signDocument(toBeSigned, parameters, signatureValue);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("SignatureOptions.setPreferredSignatureSize")) {
                return this.handleSignatureSizeError(service, parameters, toBeSigned, signatureValue, e);
            }
            throw e;
        }
    }

    private DSSDocument handleSignatureSizeError(PAdESService service, PAdESSignatureParameters parameters, DSSDocument toBeSigned, SignatureValue signatureValue, Exception e) {
        parameters.setContentSize(parameters.getContentSize() * 2);
        PAdESTimestampParameters signatureTimestampParameters = parameters.getSignatureTimestampParameters();
        if (signatureTimestampParameters != null) {
            signatureTimestampParameters.setContentSize(parameters.getContentSize());
        }
        log.info("aumentado el SignatureOptions.preferredSignatureSize a {} y volviendo a firmar porque ha ocurrido el error {}", (Object)parameters.getContentSize(), (Object)e.getMessage());
        return this.signDocument(service, parameters, toBeSigned, signatureValue);
    }

    public byte[] digest(PadesParams params, File src) {
        return null;
    }

    @Override
    public byte[] digest(PadesParams params, File src, OutputStream computed) {
        PadesDataToSignService dataToSignService = new PadesDataToSignService(this);
        dataToSignService.setValidateSignCert(false);
        try {
            ToBeSigned dataToSign = dataToSignService.build(params, src);
            ((PAdESSignatureParameters)params.getParameters()).getContext().getPdfToBeSignedCache().getToBeSignedDocument().writeTo(computed);
            byte[] byArray = dataToSign.getBytes();
            return byArray;
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
        finally {
            dataToSignService.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timestamp(PadesTimestampParams params, File src, File dest) {
        VisibleSignatureParams visibleParams = params.getVisibleSignatureParams();
        if (visibleParams != null) {
            visibleParams.init();
        }
        Object signatureDrawerFactory = visibleParams == null || visibleParams.isImageText() ? new PdfBoxDefaultSignatureDrawerFactory() : new PdfBoxCustomNativeSignatureDrawerFactory(visibleParams);
        PdfBoxSignatureObjectFactory pdfObjFactory = new PdfBoxSignatureObjectFactory((PdfBoxSignatureDrawerFactory)signatureDrawerFactory, src.length() < 0x100000L);
        try (FileOutputStream out = new FileOutputStream(dest);){
            PAdESService service = new PAdESService((CertificateVerifier)this.commonCertificateVerifier);
            service.setPdfObjFactory((IPdfObjFactory)pdfObjFactory);
            service.setTspSource(params.getTspSource());
            FileDocument toBeSigned = new FileDocument(src);
            PAdESTimestampParameters parameters = new PAdESTimestampParameters();
            parameters.setDigestAlgorithm(params.getDigestAlg());
            DSSDocument signedDocument = null;
            Object object = visibleParams != null ? visibleParams : new Object();
            synchronized (object) {
                if (visibleParams != null) {
                    DSSDocument image;
                    parameters.setImageParameters(visibleParams.getImageParameters());
                    if (visibleParams.getText() == null) {
                        visibleParams.setText("");
                    }
                    if (visibleParams.isImageText() && (image = visibleParams.getImageParameters().getImage()) == null) {
                        throw new ANFSignatureException((Throwable)new DSSException("ERR_NO_VISIBLE_IMAGE"));
                    }
                }
                double t1 = System.nanoTime();
                signedDocument = service.timestamp((DSSDocument)toBeSigned, parameters);
                log.debug("timestamp in {} ms", (Object)(((double)System.nanoTime() - t1) / 1000000.0));
            }
            Utils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
        finally {
            pdfObjFactory.clearTempFiles();
        }
    }
}

