/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.pades;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.api.tkmanager.exception.ANFCertificateException;
import com.anf.cryptotoken.sign.cert.SignatureCertValidation;
import com.anf.cryptotoken.sign.pades.PadesSignatureImpl;
import com.anf.cryptotoken.sign.pades.factory.PdfBoxSignatureObjectFactory;
import com.anf.cryptotoken.sign.pades.factory.PdfSignatureObjectFactory;
import com.anf.cryptotoken.sign.pades.params.PadesParams;
import com.anf.cryptotoken.sign.pades.params.VisibleSignatureParams;
import com.anf.cryptotoken.sign.pades.visible.PdfBoxCustomNativeSignatureDrawerFactory;
import com.anf.cryptotoken.sign.params.CertificateParams;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESService;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawerFactory;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.PdfBoxDefaultSignatureDrawerFactory;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class PadesDataToSignService {
    File tmpDir = null;
    PdfSignatureObjectFactory pdfObjFactory = null;
    PAdESService service;
    DSSDocument toBeSigned;
    PadesSignatureImpl signImpl;
    private boolean validateSignCert = true;

    public PadesDataToSignService(PadesSignatureImpl signImpl) {
        this.signImpl = signImpl;
        this.service = new PAdESService((CertificateVerifier)signImpl.getCommonCertificateVerifier());
    }

    public ToBeSigned build(PadesParams params, File src) {
        PAdESSignatureParameters parameters = this.configure(params, src);
        return this.service.getDataToSign(this.toBeSigned, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PAdESSignatureParameters configure(PadesParams params, File src) {
        PAdESSignatureParameters parameters = this.configure(params);
        CertificateParams certificateParams = params.getCertificateParams();
        X509Certificate signCert = null;
        if (this.validateSignCert) {
            SignatureCertValidation signCertValidation = this.signImpl.validateSignCert(certificateParams);
            signCert = signCertValidation.getCertificate();
        } else {
            signCert = certificateParams.getSignCert().getCertificate();
        }
        if (signCert == null || parameters.getCertificateChain() == null || parameters.getCertificateChain().isEmpty()) {
            throw new ANFCertificateException("ERR_NO_VALID_SIGN_CERT");
        }
        VisibleSignatureParams visibleParams = params.getVisibleParams();
        Object object = visibleParams != null ? visibleParams : new Object();
        synchronized (object) {
            this.configureVisibleParams(params, parameters, signCert, visibleParams);
            Object signatureDrawerFactory = visibleParams == null || visibleParams.isImageText() ? new PdfBoxDefaultSignatureDrawerFactory() : new PdfBoxCustomNativeSignatureDrawerFactory(visibleParams);
            this.pdfObjFactory = new PdfBoxSignatureObjectFactory((PdfBoxSignatureDrawerFactory)signatureDrawerFactory, src.length() < 0x100000L);
            this.service.setPdfObjFactory((IPdfObjFactory)this.pdfObjFactory);
        }
        this.toBeSigned = new FileDocument(src);
        return parameters;
    }

    public void setValidateSignCert(boolean validateSignCert) {
        this.validateSignCert = validateSignCert;
    }

    public PAdESSignatureParameters configure(PadesParams params) {
        this.service.setTspSource(params.getTspSource());
        PAdESSignatureParameters parameters = (PAdESSignatureParameters)params.getParameters();
        parameters.bLevel().setSigningDate(new Date());
        return parameters;
    }

    private void configureVisibleParams(PadesParams params, PAdESSignatureParameters parameters, X509Certificate signCert, VisibleSignatureParams visibleParams) {
        DSSDocument image;
        Date signDate = new Date();
        parameters.bLevel().setSigningDate(signDate);
        if (visibleParams != null && visibleParams.getText() == null) {
            params.setStandardVisibleText(signDate, signCert);
        }
        if (visibleParams != null) {
            visibleParams.init();
        }
        if (visibleParams != null && visibleParams.isImageText() && (image = visibleParams.getImageParameters().getImage()) == null) {
            throw new ANFSignatureException((Throwable)new DSSException("ERR_NO_VISIBLE_IMAGE"));
        }
    }

    public void clear() {
        if (this.pdfObjFactory != null) {
            this.pdfObjFactory.clearTempFiles();
        }
        if (this.tmpDir != null) {
            FileUtils.deleteQuietly((File)this.tmpDir);
        }
    }
}

