/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.factory;

import com.anf.cryptotoken.ANFControl;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.ARSignature;
import com.anf.cryptotoken.sign.AsicCadesSignature;
import com.anf.cryptotoken.sign.AsicXadesSignature;
import com.anf.cryptotoken.sign.CadesSignature;
import com.anf.cryptotoken.sign.PadesSignature;
import com.anf.cryptotoken.sign.SMimeSignature;
import com.anf.cryptotoken.sign.XadesSignature;
import com.anf.cryptotoken.sign.ar.ARSignatureImpl;
import com.anf.cryptotoken.sign.asic.AsicCadesSignatureImpl;
import com.anf.cryptotoken.sign.asic.AsicXadesSignatureImpl;
import com.anf.cryptotoken.sign.cades.CadesSignatureImpl;
import com.anf.cryptotoken.sign.pades.PadesSignatureImpl;
import com.anf.cryptotoken.sign.smime.SMimeSignatureImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateSourceFactory;
import com.anf.cryptotoken.sign.xades.XMLDSigSignatureImpl;
import com.anf.cryptotoken.sign.xades.XadesSignatureImpl;
import eu.europa.esig.dss.spi.x509.CertificateSource;

public class SignatureFactory {
    private CredentialsController credentialsController;
    CertificateSource trustedSource;

    public SignatureFactory() {
        this.credentialsController = ANFControl.get().getCredentialsController();
    }

    public SignatureFactory(CredentialsController credentialsController) {
        this.credentialsController = credentialsController;
    }

    public CadesSignature cadesSignature() {
        return new CadesSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public XadesSignature xadesSignature() {
        return new XadesSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public XadesSignature xmldsigSignature() {
        return new XMLDSigSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public PadesSignature padesSignature() {
        return new PadesSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public AsicXadesSignature asicXadesSignature() {
        return new AsicXadesSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public AsicCadesSignature asicCadesSignature() {
        return new AsicCadesSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public ARSignature arSignature() {
        return new ARSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public SMimeSignature smimeSignature() {
        return new SMimeSignatureImpl(this.credentialsController, this.getTrustedSource());
    }

    public CertificateSource getTrustedSource() {
        if (this.trustedSource == null) {
            this.trustedSource = ANFCertificateSourceFactory.getTslCertificateSource();
        }
        return this.trustedSource;
    }

    public void setTrustedSource(CertificateSource trustedSource) {
        this.trustedSource = trustedSource;
    }
}

