/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic.params;

import com.anf.cryptotoken.sign.asic.params.AsicAbstractSignatureParams;
import com.anf.cryptotoken.sign.commitments.ANFCommitmentType;
import com.anf.cryptotoken.sign.params.CertificateParams;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.util.List;

public class AsicXadesSignatureParams
extends AsicAbstractSignatureParams<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> {
    public AsicXadesSignatureParams(CertificateParams certificateParams, ASiCWithXAdESSignatureParameters params) {
        super(certificateParams, params);
    }

    public AsicXadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType, Policy signaturePolicy, List<ANFCommitmentType> commitments) {
        super(certificateParams, digestAlg, level, signaturePolicy, commitments);
        ((ASiCWithXAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    public AsicXadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType, Policy signaturePolicy) {
        super(certificateParams, digestAlg, level, signaturePolicy);
        ((ASiCWithXAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    public AsicXadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType) {
        super(certificateParams, digestAlg, level);
        ((ASiCWithXAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    @Override
    protected ASiCWithXAdESSignatureParameters createParameters() {
        ASiCWithXAdESSignatureParameters aSiCWithCAdESSignatureParameters = new ASiCWithXAdESSignatureParameters();
        aSiCWithCAdESSignatureParameters.aSiC().setContainerType(ASiCContainerType.ASiC_E);
        XAdESTimestampParameters timestampParameters = new XAdESTimestampParameters(this.digestAlg);
        aSiCWithCAdESSignatureParameters.setArchiveTimestampParameters((SerializableTimestampParameters)timestampParameters);
        aSiCWithCAdESSignatureParameters.setContentTimestampParameters((SerializableTimestampParameters)timestampParameters);
        aSiCWithCAdESSignatureParameters.setSignatureTimestampParameters((SerializableTimestampParameters)timestampParameters);
        return aSiCWithCAdESSignatureParameters;
    }
}

