/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic.params;

import com.anf.cryptotoken.sign.asic.params.AsicAbstractSignatureParams;
import com.anf.cryptotoken.sign.commitments.ANFCommitmentType;
import com.anf.cryptotoken.sign.params.CertificateParams;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import java.util.List;

public class AsicCadesSignatureParams
extends AsicAbstractSignatureParams<ASiCWithCAdESSignatureParameters, CAdESTimestampParameters> {
    public AsicCadesSignatureParams(CertificateParams certificateParams, ASiCWithCAdESSignatureParameters params) {
        super(certificateParams, params);
    }

    public AsicCadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType, Policy signaturePolicy, List<ANFCommitmentType> commitments) {
        super(certificateParams, digestAlg, level, signaturePolicy, commitments);
        ((ASiCWithCAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    public AsicCadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType, Policy signaturePolicy) {
        super(certificateParams, digestAlg, level, signaturePolicy);
        ((ASiCWithCAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    public AsicCadesSignatureParams(CertificateParams certificateParams, DigestAlgorithm digestAlg, SignatureLevel level, ASiCContainerType containerType) {
        super(certificateParams, digestAlg, level);
        ((ASiCWithCAdESSignatureParameters)this.getParameters()).aSiC().setContainerType(containerType);
    }

    @Override
    protected ASiCWithCAdESSignatureParameters createParameters() {
        ASiCWithCAdESSignatureParameters aSiCWithCAdESSignatureParameters = new ASiCWithCAdESSignatureParameters();
        aSiCWithCAdESSignatureParameters.aSiC().setContainerType(ASiCContainerType.ASiC_E);
        CAdESTimestampParameters timestampParameters = new CAdESTimestampParameters(this.digestAlg);
        aSiCWithCAdESSignatureParameters.setArchiveTimestampParameters((SerializableTimestampParameters)timestampParameters);
        aSiCWithCAdESSignatureParameters.setContentTimestampParameters((SerializableTimestampParameters)timestampParameters);
        aSiCWithCAdESSignatureParameters.setSignatureTimestampParameters((SerializableTimestampParameters)timestampParameters);
        return aSiCWithCAdESSignatureParameters;
    }
}

