/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic;

import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.AsicXadesSignature;
import com.anf.cryptotoken.sign.asic.AsicXadesDataToSignService;
import com.anf.cryptotoken.sign.asic.params.AsicXadesSignatureParams;
import com.anf.cryptotoken.sign.params.CertificateParams;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.anf.cryptotoken.sign.verifier.error.SignatureAlertError;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.io.IOUtils;

public class AsicXadesSignatureImpl
extends AbstractSignature
implements AsicXadesSignature {
    public AsicXadesSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    public AsicXadesSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public AsicXadesSignatureImpl() {
    }

    public void sign(AsicXadesSignatureParams params, File src, File dest) {
        this.sign(params, List.of(src), dest);
    }

    @Override
    public void sign(AsicXadesSignatureParams params, List<File> src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            CertificateParams certificateParams = params.getCertificateParams();
            ASiCWithXAdESSignatureParameters parameters = (ASiCWithXAdESSignatureParameters)params.getParameters();
            this.validateSignCert(certificateParams);
            AsicXadesDataToSignService asicXadesDataToSignService = new AsicXadesDataToSignService(this);
            ToBeSigned dataToSign = asicXadesDataToSignService.build(params, src);
            SignatureToken token = certificateParams.getSignatureToken();
            DSSPrivateKeyEntry keyInfo = certificateParams.getKeyInfo();
            SignatureValue signatureValue = token.sign(dataToSign, parameters.getDigestAlgorithm(), keyInfo);
            DSSDocument signedDocument = asicXadesDataToSignService.service.signDocument(asicXadesDataToSignService.toBeSigned, parameters, signatureValue);
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public byte[] digest(AsicXadesSignatureParams params, File src) {
        return this.digest(params, List.of(src));
    }

    public void sign(AsicXadesSignatureParams params, byte[] signature, File src, File dest) {
        this.sign(params, signature, List.of(src), dest);
    }

    @Override
    public void sign(AsicXadesSignatureParams params, byte[] signature, List<File> src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            AsicXadesDataToSignService asicCadesDataToSignService = new AsicXadesDataToSignService(this);
            ASiCWithXAdESSignatureParameters parameters = asicCadesDataToSignService.configure(params, src);
            DSSDocument signedDocument = asicCadesDataToSignService.service.signDocument(asicCadesDataToSignService.toBeSigned, parameters, new SignatureValue(parameters.getSignatureAlgorithm(), signature));
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    @Override
    public byte[] digest(AsicXadesSignatureParams params, List<File> src) {
        try {
            AsicXadesDataToSignService asicXadesDataToSignService = new AsicXadesDataToSignService(this);
            ToBeSigned dataToSign = asicXadesDataToSignService.build(params, src);
            return dataToSign.getBytes();
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }

    public void extend(AsicXadesSignatureParams params, File src, File dest) {
        try (FileOutputStream out = new FileOutputStream(dest);){
            AsicXadesDataToSignService asicCadesDataToSignService = new AsicXadesDataToSignService(this);
            ASiCWithXAdESSignatureParameters parameters = asicCadesDataToSignService.configure(params);
            DSSDocument signedDocument = asicCadesDataToSignService.service.extendDocument((DSSDocument)new FileDocument(src), parameters);
            IOUtils.copy((InputStream)signedDocument.openStream(), (OutputStream)out);
        }
        catch (SignatureAlertError alertError) {
            throw alertError;
        }
        catch (Exception e) {
            throw new ANFSignatureException((Throwable)e);
        }
    }
}

