/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.asic;

import com.anf.cryptotoken.sign.asic.AsicCadesSignatureImpl;
import com.anf.cryptotoken.sign.asic.params.AsicCadesSignatureParams;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AsicCadesDataToSignService {
    ASiCWithCAdESService service;
    List<DSSDocument> toBeSigned;
    AsicCadesSignatureImpl signImpl;

    public AsicCadesDataToSignService(AsicCadesSignatureImpl signImpl) {
        this.signImpl = signImpl;
    }

    public ToBeSigned build(AsicCadesSignatureParams params, List<File> src) {
        ASiCWithCAdESSignatureParameters parameters = this.configure(params, src);
        return this.service.getDataToSign(this.toBeSigned, parameters);
    }

    public ASiCWithCAdESSignatureParameters configure(AsicCadesSignatureParams params, List<File> src) {
        ASiCWithCAdESSignatureParameters parameters = this.configure(params);
        this.toBeSigned = new ArrayList<DSSDocument>();
        this.toBeSigned.addAll(src.stream().map(FileDocument::new).toList());
        return parameters;
    }

    public ASiCWithCAdESSignatureParameters configure(AsicCadesSignatureParams params) {
        this.service = new ASiCWithCAdESService((CertificateVerifier)this.signImpl.getCommonCertificateVerifier());
        this.service.setTspSource(params.getTspSource());
        ASiCWithCAdESSignatureParameters parameters = (ASiCWithCAdESSignatureParameters)params.getParameters();
        return parameters;
    }
}

