/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.ar;

import com.anf.cryptotoken.api.io.Locker;
import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.api.sign.exception.ANFSignatureException;
import com.anf.cryptotoken.config.Confis;
import com.anf.cryptotoken.credentials.CredentialsController;
import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.ARSignature;
import com.anf.cryptotoken.sign.AbstractSignature;
import com.anf.cryptotoken.sign.ar.ANFContentSigner;
import com.anf.cryptotoken.sign.ar.params.ARParams;
import com.anf.cryptotoken.sign.cert.SignatureCertValidation;
import com.anf.cryptotoken.sign.token.SignatureToken;
import com.sun.mail.util.BASE64DecoderStream;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class ARSignatureImpl
extends AbstractSignature
implements ARSignature {
    private static final Logger log = Logger.getLogger(ARSignatureImpl.class);

    public ARSignatureImpl() {
        this(false, true);
    }

    public ARSignatureImpl(CredentialsController credentialsController, CertificateSource certificateSource) {
        super(credentialsController, certificateSource);
    }

    public ARSignatureImpl(boolean validateIfCertIsQualified, boolean validateCertOCSPStatus) {
        super(validateIfCertIsQualified, validateCertOCSPStatus);
    }

    public void sign(ARParams params, File input, File output) {
        SignatureToken signToken = params.getCertificateParams().getSignatureToken();
        ANFSignatureToken tk = signToken.getAnfToken();
        String serialNumberToken = signToken.getSerial();
        String alias = signToken.getAlias();
        try (Locker locker = tk.getLocker(serialNumberToken);){
            SignatureCertValidation signCertValidation = this.validateSignCert(params.getCertificateParams());
            X509Certificate signingCert = signCertValidation.getCertificate();
            X509Certificate[] chain = signCertValidation.getChain();
            Provider p = tk.isSignatureDevice(serialNumberToken) ? tk.getSignProvider(serialNumberToken) : null;
            ARSignatureImpl.generateMultiPartRsa(input, input.getName(), output, tk, serialNumberToken, alias, "SHA256withRSA", new Date(), SMIMESignedGenerator.RFC3851_MICALGS, chain, signingCert, p);
        }
        catch (Throwable e) {
            throw new ANFSignatureException(e);
        }
    }

    public byte[] digest(ARParams params, File src) {
        throw new UnsupportedOperationException("digest not supported");
    }

    public void sign(ARParams params, byte[] signature, File src, File dest) {
        throw new UnsupportedOperationException("signature build not supported");
    }

    public static MimeMultipart generateMultiPartRsa(File src, String name, File dest, ANFSignatureToken tk, String serial, String alias, String algorithm, Date signingTime, Map micalgs, X509Certificate[] sortCertificateChain, X509Certificate signingCert, Provider p) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (int i = 0; i < sortCertificateChain.length; ++i) {
            System.out.println(sortCertificateChain[i].getSubjectX500Principal());
            certList.add(sortCertificateChain[i]);
        }
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = ARSignatureImpl.generateSignedAttributes();
        if (signingTime != null) {
            signedAttrs.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signingTime))));
        }
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addCertificates((Store)certs);
        SignerInfoGenerator generador = null;
        if (p == null) {
            PrivateKey privKey = tk.getPrivateKey(serial, alias);
            JcaSimpleSignerInfoGeneratorBuilder signedAttributeGenerator = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setDirectSignature(false).setUnsignedAttributeGenerator(null).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs)));
            generador = signedAttributeGenerator.build(algorithm, privKey, signingCert);
            gen.addSignerInfoGenerator(generador);
        } else {
            SignerInfoGeneratorBuilder infoGeneratorBuilder = new SignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build());
            infoGeneratorBuilder.setDirectSignature(false);
            infoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs)));
            infoGeneratorBuilder.setUnsignedAttributeGenerator(null);
            ANFContentSigner signer = new ANFContentSigner(tk, serial, alias, algorithm);
            generador = infoGeneratorBuilder.build((ContentSigner)signer, (X509CertificateHolder)new JcaX509CertificateHolder(signingCert));
        }
        gen.addSignerInfoGenerator(generador);
        CMSSignedData signed = gen.generate((CMSTypedData)new CMSProcessableFile(src), false);
        FileOutputStream destino = new FileOutputStream(dest);
        ARSignatureImpl.originalMasFirma(src, name, signed.getEncoded(), destino, micalgs);
        destino.close();
        return null;
    }

    private static String originalMasFirma(File contentFile, String name, byte[] firma, OutputStream destino, Map<Object, Object> headers) {
        try {
            File temporalFirma = new File(Files.temp, System.nanoTime() + "-smime.p7s");
            temporalFirma.createNewFile();
            FileOutputStream fos = new FileOutputStream(temporalFirma);
            fos.write(firma);
            fos.close();
            StringBuffer header = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"; micalg=sha1");
            MimeMultipart mp = new MimeMultipart(header.toString());
            MimeBodyPart documento = new MimeBodyPart();
            documento.attachFile(contentFile);
            documento.setHeader("Content-Transfer-Encoding", "base64");
            mp.addBodyPart((BodyPart)documento);
            MimeBodyPart fir = new MimeBodyPart();
            fir.attachFile(temporalFirma);
            String additionalInfo = "S/MIME Cryptographic Signature";
            fir.setFileName(temporalFirma.getName());
            fir.setDescription(additionalInfo);
            fir.setHeader("Content-Type", "application/pkcs7-signature; name=" + temporalFirma.getName() + "; smime-type=signed-data");
            fir.setHeader("Content-Disposition", "attachment; filename=\"" + temporalFirma.getName() + "\"");
            mp.addBodyPart((BodyPart)fir);
            MimeMessage mm = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()));
            mm.setContent((Multipart)mp);
            mm.writeTo(destino);
            destino.close();
            return null;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return ex.getMessage();
        }
    }

    private static ASN1EncodableVector generateSignedAttributes() {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        return signedAttrs;
    }

    public ArrayList<X509Certificate> sortCertificateChain(X509Certificate[] CertificateChain) throws Exception {
        ArrayList<X509Certificate> certificateChainOrdered = new ArrayList<X509Certificate>();
        ArrayList<X509Certificate> certificateChainNoCA = new ArrayList<X509Certificate>();
        for (X509Certificate item : CertificateChain) {
            X500Principal suerX500Principal;
            X500Principal subjectX500Principal = item.getSubjectX500Principal();
            if (subjectX500Principal.equals(suerX500Principal = item.getIssuerX500Principal())) {
                boolean[] subjectUniqueID = item.getSubjectUniqueID();
                boolean[] suerUniqueID = item.getIssuerUniqueID();
                if (Arrays.equals(suerUniqueID, subjectUniqueID)) {
                    certificateChainOrdered.add(item);
                    continue;
                }
                certificateChainNoCA.add(item);
                continue;
            }
            certificateChainNoCA.add(item);
        }
        if (!certificateChainOrdered.isEmpty()) {
            return this.sortCertificateChain(certificateChainOrdered, certificateChainNoCA);
        }
        throw new Exception(Confis.get().getString("1", new Object[0]));
    }

    private ArrayList<X509Certificate> sortCertificateChain(ArrayList<X509Certificate> certificateChainOrdered, ArrayList<X509Certificate> certificateChainNoCA) {
        X509Certificate toRemove = null;
        X509Certificate lastCert = certificateChainOrdered.get(certificateChainOrdered.size() - 1);
        for (X509Certificate item : certificateChainNoCA) {
            X500Principal suerX500Principal;
            X500Principal subjectX500Principal = lastCert.getSubjectX500Principal();
            if (!subjectX500Principal.equals(suerX500Principal = item.getIssuerX500Principal())) continue;
            boolean[] subjectUniqueID = item.getSubjectUniqueID();
            boolean[] suerUniqueID = item.getIssuerUniqueID();
            if (!Arrays.equals(suerUniqueID, subjectUniqueID)) continue;
            certificateChainOrdered.add(item);
            toRemove = item;
            break;
        }
        certificateChainNoCA.remove(toRemove);
        if (certificateChainNoCA.isEmpty()) {
            return certificateChainOrdered;
        }
        return this.sortCertificateChain(certificateChainOrdered, certificateChainNoCA);
    }

    public static ByteArrayOutputStream getSignedContent(File file) {
        FileDataSource ds = new FileDataSource(file);
        return ARSignatureImpl.getSignedContent((DataSource)ds);
    }

    public static String getSignedFileName(File file) {
        FileDataSource ds = new FileDataSource(file);
        return ARSignatureImpl.getFileName((DataSource)ds);
    }

    public static String getSignedFileName(byte[] content) {
        ByteArrayDataSource ds = new ByteArrayDataSource(content, "application/pkcs7-signature");
        return ARSignatureImpl.getFileName((DataSource)ds);
    }

    public static ByteArrayOutputStream getSignedContent(byte[] content) {
        ByteArrayDataSource ds = new ByteArrayDataSource(content, "application/pkcs7-signature");
        return ARSignatureImpl.getSignedContent((DataSource)ds);
    }

    private static ByteArrayOutputStream getSignedContent(DataSource ds) {
        try {
            MimeMultipart mp = new MimeMultipart(ds);
            if (mp.getCount() >= 2) {
                MimeBodyPart documento = (MimeBodyPart)mp.getBodyPart(0);
                byte[] content = null;
                String encoding = documento.getEncoding();
                if (encoding != null && encoding.equalsIgnoreCase("base64") && documento.getContent() instanceof BASE64DecoderStream) {
                    BASE64DecoderStream decoder = (BASE64DecoderStream)documento.getContent();
                    content = IOUtils.toByteArray((InputStream)decoder);
                } else if (mp.getContentType() != null && mp.getContentType().equals("application/octet-stream") && documento.getContent() instanceof String) {
                    content = ((String)documento.getContent()).getBytes();
                }
                if (content != null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(content.length);
                    out.write(content);
                    return out;
                }
            }
        }
        catch (MessagingException | IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    private static String getFileName(DataSource ds) {
        try {
            MimeMultipart mp = new MimeMultipart(ds);
            if (mp.getCount() >= 2) {
                return mp.getBodyPart(0).getFileName();
            }
        }
        catch (MessagingException e) {
            log.error((Object)e);
        }
        return null;
    }
}

