/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.ar;

import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.log.Logger;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public class ANFContentSigner
implements ContentSigner {
    private static final Logger log = Logger.getLogger(ANFContentSigner.class);
    private String alg;
    private AlgorithmIdentifier sigAlgId;
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private ANFSignatureToken tk;
    private String serial;
    private String alias;
    private char[] pin;

    public ANFContentSigner(ANFSignatureToken tk, String serial, String alias, String alg, char[] pin) {
        this.alg = alg;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(alg);
        this.tk = tk;
        this.serial = serial;
        this.alias = alias;
        this.pin = pin;
    }

    public ANFContentSigner(ANFSignatureToken tk, String serial, String alias, String alg) {
        this(tk, serial, alias, alg, null);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.sigAlgId;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    public byte[] getSignature() {
        byte[] data = this.stream.toByteArray();
        try {
            if (this.pin != null) {
                return this.tk.signData(this.serial, this.alias, data, this.alg, this.pin);
            }
            return this.tk.signData(this.serial, this.alias, data, this.alg);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

