/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.evidencerecord.AbstractSignatureEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;

public class CAdESEvidenceRecordDigestBuilder
extends AbstractSignatureEvidenceRecordDigestBuilder {
    protected DSSDocument detachedDocument;

    public CAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument) {
        super(signatureDocument);
    }

    public CAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument, DigestAlgorithm digestAlgorithm) {
        super(signatureDocument, digestAlgorithm);
    }

    public CAdESEvidenceRecordDigestBuilder setDetachedContent(DSSDocument detachedDocument) {
        this.detachedDocument = detachedDocument;
        return this;
    }

    public CAdESEvidenceRecordDigestBuilder setParallelEvidenceRecord(boolean parallelEvidenceRecord) {
        return (CAdESEvidenceRecordDigestBuilder)super.setParallelEvidenceRecord(parallelEvidenceRecord);
    }

    public Digest build() {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)this.signatureDocument);
        return this.getDigest(cmsSignedData);
    }

    public List<Digest> buildExternalEvidenceRecordDigest() {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)this.signatureDocument);
        Digest signatureDigest = this.getDigest(cmsSignedData);
        Digest originalDocumentDigest = this.getDigest(this.detachedDocument);
        return Arrays.asList(signatureDigest, originalDocumentDigest);
    }

    protected Digest getDigest(CMSSignedData cmsSignedData) {
        byte[] messageImprint = this.getCMSSignedDataMessageImprint(cmsSignedData);
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])messageImprint);
        return new Digest(this.digestAlgorithm, digest);
    }

    protected byte[] getCMSSignedDataMessageImprint(CMSSignedData cmsSignedData) {
        if (this.parallelEvidenceRecord) {
            cmsSignedData = this.getCMSSignedDataBeforeLastEvidenceRecord(cmsSignedData);
        }
        return DSSASN1Utils.getDEREncoded((CMSSignedData)cmsSignedData);
    }

    protected CMSSignedData getCMSSignedDataBeforeLastEvidenceRecord(CMSSignedData cmsSignedData) {
        boolean signerWithERFound = false;
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : cmsSignedData.getSignerInfos().getSigners()) {
            AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
            Attribute latestEvidenceRecordAttribute = this.getLatestEvidenceRecordAttribute(unsignedAttributes);
            if (latestEvidenceRecordAttribute != null) {
                if (signerWithERFound) {
                    throw new IllegalInputException("The CMSSignedData contains multiple evidence record attributes! Unable to compute hash.");
                }
                if ((unsignedAttributes = this.removeAttribute(unsignedAttributes, latestEvidenceRecordAttribute)).size() == 0) {
                    unsignedAttributes = null;
                }
                signerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
                signerWithERFound = true;
            }
            newSignerInformationList.add(signerInformation);
        }
        return CMSSignedData.replaceSigners((CMSSignedData)cmsSignedData, (SignerInformationStore)new SignerInformationStore(newSignerInformationList));
    }

    private Attribute getLatestEvidenceRecordAttribute(AttributeTable attributeTable) {
        Object latestERAttribute = null;
        if (attributeTable != null) {
            Date latestERProductionDate = null;
            Object[] attributes = attributeTable.toASN1Structure().getAttributes();
            if (Utils.isArrayNotEmpty((Object[])attributes)) {
                for (Object attribute : attributes) {
                    if (!this.isERAttribute((Attribute)attribute)) continue;
                    Date attributeProductionTime = this.getERAttributeProductionTime((Attribute)attribute);
                    if (latestERProductionDate != null && (attributeProductionTime == null || !attributeProductionTime.after(latestERProductionDate))) continue;
                    latestERAttribute = attribute;
                    latestERProductionDate = attributeProductionTime;
                }
            }
        }
        return latestERAttribute;
    }

    private boolean isERAttribute(Attribute attribute) {
        return OID.id_aa_er_internal.equals((ASN1Primitive)attribute.getAttrType()) || OID.id_aa_er_external.equals((ASN1Primitive)attribute.getAttrType());
    }

    private Date getERAttributeProductionTime(Attribute attribute) {
        Date earliestProductionTime = null;
        for (ASN1Encodable asn1Encodable : attribute.getAttributeValues()) {
            Date erProductionTime = this.getERProductionTime(asn1Encodable);
            if (earliestProductionTime != null && !erProductionTime.before(earliestProductionTime)) continue;
            earliestProductionTime = erProductionTime;
        }
        return earliestProductionTime;
    }

    private Date getERProductionTime(ASN1Encodable asn1Encodable) {
        try {
            EvidenceRecord evidenceRecord = EvidenceRecord.getInstance((Object)asn1Encodable);
            if (evidenceRecord == null) {
                throw new IllegalInputException("Unable to build an evidence record!");
            }
            Object[] archiveTimeStampChains = evidenceRecord.getArchiveTimeStampSequence().getArchiveTimeStampChains();
            if (Utils.isArrayEmpty((Object[])archiveTimeStampChains)) {
                throw new IllegalInputException("No archive time-stamp chains found within evidence record!");
            }
            Object archiveTimeStampChain = archiveTimeStampChains[0];
            Object[] archiveTimestamps = archiveTimeStampChain.getArchiveTimestamps();
            if (Utils.isArrayEmpty((Object[])archiveTimestamps)) {
                throw new IllegalInputException("No archive time-stamps found within evidence record!");
            }
            Object archiveTimestamp = archiveTimestamps[0];
            return new TimeStampToken(archiveTimestamp.getTimeStamp()).getTimeStampInfo().getGenTime();
        }
        catch (IOException | TSPException e) {
            throw new DSSException(String.format("Unable to build embedded time-stamp! Reason : %s", e.getMessage()), e);
        }
    }

    private AttributeTable removeAttribute(AttributeTable attributeTable, Attribute attributeToRemove) {
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        for (Attribute attribute : attributeTable.toASN1Structure().getAttributes()) {
            if (attributeToRemove == attribute) continue;
            asn1EncodableVector.add((ASN1Encodable)attribute);
        }
        return new AttributeTable(asn1EncodableVector);
    }
}

