/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.TimeStampTokenProductionComparator;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzer;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.x509.CMSSignedDataBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineLT
extends CAdESLevelBaselineT {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineLT.class);

    public CAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        super(tspSource, certificateVerifier);
    }

    @Override
    protected CMSSignedData extendCMSSignatures(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters, List<String> signatureIdsToExtend) {
        CMSDocumentAnalyzer documentAnalyzer = this.getDocumentValidator(cmsSignedData = super.extendCMSSignatures(cmsSignedData, parameters, signatureIdsToExtend), parameters);
        List signatures = documentAnalyzer.getSignatures();
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures, signatureIdsToExtend);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return cmsSignedData;
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker(parameters);
        if (SignatureLevel.CAdES_BASELINE_LT.equals((Object)parameters.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = documentAnalyzer.getValidationData(signaturesToExtend);
        if (this.includesATSv2(cmsSignedData)) {
            ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
            for (AdvancedSignature signature : signatures) {
                SignerInformation signerInformation;
                CAdESSignature cadesSignature = (CAdESSignature)signature;
                SignerInformation newSignerInformation = signerInformation = cadesSignature.getSignerInformation();
                if (signaturesToExtend.contains((Object)cadesSignature)) {
                    ValidationData validationData = validationDataContainer.getAllValidationDataForSignatureForInclusion((AdvancedSignature)cadesSignature);
                    newSignerInformation = this.extendSignerInformation(signerInformation, validationData);
                }
                newSignerInformationList.add(newSignerInformation);
            }
            cmsSignedData = this.replaceSigners(cmsSignedData, newSignerInformationList);
        } else {
            ValidationData allValidationData = validationDataContainer.getAllValidationData();
            for (AdvancedSignature signature : signaturesToExtend) {
                allValidationData.excludeCertificateTokens((Collection)signature.getCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens((Collection)signature.getCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens((Collection)signature.getOCSPSource().getAllRevocationBinaries());
            }
            cmsSignedData = this.extendWithValidationData(cmsSignedData, allValidationData);
        }
        return cmsSignedData;
    }

    private SignerInformation extendSignerInformation(SignerInformation signerInformation, ValidationData validationData) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        unsignedAttributes = this.addValidationData(unsignedAttributes, validationData);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
    }

    private AttributeTable addValidationData(AttributeTable unsignedAttributes, ValidationData validationData) {
        TimeStampToken timestampTokenToExtend = this.getLastArchiveTimestamp(unsignedAttributes);
        if (timestampTokenToExtend != null) {
            CMSSignedData timestampCMSSignedData = timestampTokenToExtend.toCMSSignedData();
            CMSSignedData extendedTimestampCMSSignedData = this.extendWithValidationData(timestampCMSSignedData, validationData);
            unsignedAttributes = this.replaceTimeStampAttribute(unsignedAttributes, timestampCMSSignedData, extendedTimestampCMSSignedData);
        }
        return unsignedAttributes;
    }

    private TimeStampToken getLastArchiveTimestamp(AttributeTable unsignedAttributes) {
        TimeStampToken lastTimeStampToken = null;
        TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
        for (TimeStampToken timeStampToken : CMSUtils.findArchiveTimeStampTokens(unsignedAttributes)) {
            if (lastTimeStampToken != null && !comparator.after(timeStampToken, lastTimeStampToken)) continue;
            lastTimeStampToken = timeStampToken;
        }
        return lastTimeStampToken;
    }

    private AttributeTable replaceTimeStampAttribute(AttributeTable attributeTable, CMSSignedData attributeToReplace, CMSSignedData attributeToAdd) {
        Attribute[] attributes;
        ASN1EncodableVector newAsn1EncodableVector = new ASN1EncodableVector();
        Attribute[] attributeArray = attributes = attributeTable.toASN1Structure().getAttributes();
        int n = attributeArray.length;
        for (int i = 0; i < n; ++i) {
            Attribute attribute;
            Attribute newAttribute = attribute = attributeArray[i];
            if (CMSUtils.isArchiveTimeStampToken(attribute)) {
                try {
                    CMSSignedData cmsSignedData = CMSUtils.getCMSSignedData(attribute);
                    if (cmsSignedData != null && CMSUtils.isCMSSignedDataEqual(attributeToReplace, cmsSignedData)) {
                        ASN1Primitive asn1Primitive = DSSASN1Utils.toASN1Primitive((byte[])attributeToAdd.getEncoded());
                        newAttribute = new Attribute(attribute.getAttrType(), (ASN1Set)new DERSet((ASN1Encodable)asn1Primitive));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to build a CMSSignedData object from an unsigned attribute. Reason : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            newAsn1EncodableVector.add((ASN1Encodable)newAttribute);
        }
        return new AttributeTable(newAsn1EncodableVector);
    }

    private CMSSignedData extendWithValidationData(CMSSignedData cmsSignedData, ValidationData validationDataForInclusion) {
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder().setOriginalCMSSignedData(cmsSignedData);
        return cmsSignedDataBuilder.extendCMSSignedData((Collection)validationDataForInclusion.getCertificateTokens(), (Collection)validationDataForInclusion.getCrlTokens(), (Collection)validationDataForInclusion.getOcspTokens());
    }

    protected boolean includesATSv2(CMSSignedData cmsSignedData) {
        for (SignerInformation signerInformation : cmsSignedData.getSignerInfos()) {
            if (!CMSUtils.containsATSTv2(signerInformation)) continue;
            return true;
        }
        return false;
    }

    protected List<AdvancedSignature> getExtendToLTLevelSignatures(List<AdvancedSignature> signatures, List<String> signatureIdsToExtend) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!signatureIdsToExtend.contains(signature.getId())) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }
}

