/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cert.utils;

import com.anf.cert.utils.AgregarProveedor;
import com.anf.trust.certs.CertResourceHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class CertUtils {
    private static final Logger log = LogManager.getLogger(CertUtils.class);
    private static Map<String, X509Certificate> issuerCache;

    public static X509Certificate getCert(InputStream ci) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(ci);
            return cert;
        }
        catch (NoSuchProviderException | CertificateException e) {
            log.error("error cert inputstream", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static X509Certificate[] getCertificates(InputStream pkcs7Response) throws CMSException, CertificateException {
        CMSSignedData data = new CMSSignedData(pkcs7Response);
        Store store = data.getCertificates();
        Collection hold = store.getMatches(null);
        Iterator it = hold.iterator();
        X509Certificate[] chain = new X509Certificate[hold.size()];
        int x = 0;
        while (it.hasNext()) {
            X509CertificateHolder hold1 = (X509CertificateHolder)it.next();
            chain[x] = new JcaX509CertificateConverter().setProvider("BC").getCertificate(hold1);
            ++x;
        }
        return CertUtils.sortChain(chain);
    }

    public static X509Certificate[] fillChain(X509Certificate ... chain) {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        int finalCert = CertUtils.getFinalCert(chain);
        if (finalCert != -1) {
            X509Certificate cursor = chain[finalCert];
            certList.add(cursor);
            do {
                if ((cursor = CertUtils.getIssuerCertificate(chain, cursor)) == null) continue;
                certList.add(cursor);
            } while (cursor != null && !CertUtils.isSelfSigned(cursor));
        }
        return certList.toArray(new X509Certificate[0]);
    }

    public static X509Certificate[] buildChain(X509Certificate ... chain) {
        if (chain.length == 1) {
            X509Certificate[] chain2 = chain;
            X509Certificate finalCert = chain[0];
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.add(finalCert);
            boolean findRoot = false;
            X509Certificate issuerCertificate = null;
            X509Certificate cursor = finalCert;
            int c = 0;
            do {
                if ((issuerCertificate = CertUtils.getIssuerCertificate(chain, cursor)) != null) {
                    c = 0;
                    certs.add(issuerCertificate);
                    cursor = issuerCertificate;
                    findRoot = CertUtils.isSelfSigned(cursor);
                    continue;
                }
                ++c;
            } while (c < 10 && !findRoot && issuerCertificate != null);
            if (certs.size() > 1) {
                chain2 = new X509Certificate[certs.size()];
                certs.toArray(chain2);
            }
            return chain2;
        }
        return chain;
    }

    public static X509Certificate getIssuerCertificate(X509Certificate[] chain, X509Certificate certificate) {
        return CertUtils.getIssuerCertificate(chain, certificate, false);
    }

    public static X509Certificate getIssuerCertificate(X509Certificate[] chain, X509Certificate certificate, boolean findInChain) {
        if (chain.length > 1) {
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate result = chain[i];
                if (!CertUtils.isIssuer(certificate, result)) continue;
                return result;
            }
        }
        if (!findInChain) {
            return CertUtils.getIssuerCertificate(certificate);
        }
        return null;
    }

    public static X509Certificate convertCertToX509CertImpl(X509Certificate cert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        }
        catch (NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
        return cert;
    }

    public static boolean checkIssuer(X509Certificate issuer, X509Certificate uploaded) {
        X500Principal issuerDN;
        X500Principal subjectDN = issuer.getSubjectX500Principal();
        if (!subjectDN.equals(issuerDN = uploaded.getIssuerX500Principal())) {
            return false;
        }
        PublicKey pubKey = issuer.getPublicKey();
        try {
            uploaded.verify(pubKey);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isIssuer(X509Certificate certificate, X509Certificate issuer) {
        return CertUtils.checkIssuer(issuer, certificate);
    }

    public static X509Certificate getIssuerCertificate(X509Certificate certificate) {
        if (CertUtils.isSelfSigned(certificate) || CertUtils.isRootCert(certificate)) {
            return null;
        }
        log.info("getIssuerCertificate: subject: {} issuer: {}", (Object)certificate.getSubjectX500Principal(), (Object)certificate.getIssuerX500Principal());
        String cacheKey = Base64.getEncoder().encodeToString(certificate.getSignature());
        X509Certificate issuer = issuerCache.get(cacheKey);
        if (issuer == null) {
            issuer = CertResourceHandler.getHandler().findIssuerCert(certificate);
        }
        if (issuer == null) {
            issuer = CertUtils.getIssuerFromCertUrl(certificate);
        }
        if (issuer != null) {
            issuerCache.put(cacheKey, issuer);
        }
        return issuer;
    }

    public static String getIssuerUrl(X509Certificate certificate) {
        try {
            byte[] extVal = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (extVal != null) {
                AccessDescription[] descriptions;
                AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extVal));
                for (AccessDescription ad : descriptions = aia.getAccessDescriptions()) {
                    GeneralName location;
                    if (!ad.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.id_ad_caIssuers) || (location = ad.getAccessLocation()).getTagNo() != 6) continue;
                    return location.getName().toString();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    public static X509Certificate getIssuerFromCertUrl(X509Certificate certificate) {
        block7: {
            try {
                String issuerUrl = CertUtils.getIssuerUrl(certificate);
                if (issuerUrl == null) break block7;
                URL url = new URL(issuerUrl);
                byte[] content = CertUtils.read(url);
                X509Certificate bestIssuer = null;
                try {
                    X509Certificate[] certs;
                    block8: {
                        certs = null;
                        try {
                            certs = CertUtils.loadCertificatesCMS(content);
                        }
                        catch (Exception e) {
                            PemReader pemReader = new PemReader((Reader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content))));
                            PemObject readPemObject = pemReader.readPemObject();
                            if (!readPemObject.getType().equals("PKCS7")) break block8;
                            certs = CertUtils.loadCertificatesCMS(readPemObject.getContent());
                        }
                    }
                    for (X509Certificate issuer : certs) {
                        if (!CertUtils.isIssuer(certificate, issuer) || bestIssuer != null && !issuer.getNotAfter().after(bestIssuer.getNotAfter())) continue;
                        bestIssuer = issuer;
                    }
                    return bestIssuer;
                }
                catch (Exception e) {
                    return CertUtils.getCert(new ByteArrayInputStream(content));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public static X509Certificate[] loadCertificatesCMS(byte[] cms) throws CMSException {
        return new CMSSignedData((InputStream)new ByteArrayInputStream(cms)).getCertificates().getMatches(null).stream().map(hold1 -> {
            try {
                return new JcaX509CertificateConverter().setProvider("BC").getCertificate(hold1);
            }
            catch (CertificateException e1) {
                log.error("error al cargar certificado de pkcs7 {}", hold1, (Object)e1);
                return null;
            }
        }).filter(Objects::nonNull).toList().toArray(new X509Certificate[0]);
    }

    public static X509Certificate readCert(URL url) throws IOException {
        byte[] content = CertUtils.read(url);
        return CertUtils.getCert(new ByteArrayInputStream(content));
    }

    private static byte[] read(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection https = (HttpsURLConnection)con;
            CertUtils.setTrustAll(https);
        }
        con.setInstanceFollowRedirects(false);
        con.setDoInput(true);
        int responseCode = con.getResponseCode();
        if (responseCode == 301 || responseCode == 302) {
            String location = con.getHeaderField("Location");
            log.debug("response code for url {} is {}, location: {}", (Object)url.toExternalForm(), (Object)responseCode, (Object)location);
            if (location != null) {
                return CertUtils.read(new URL(location));
            }
        } else if (responseCode == 200) {
            byte[] content = IOUtils.toByteArray((InputStream)con.getInputStream());
            log.debug("response code for url {} is 200 OK, content length: {}", (Object)url.toExternalForm(), (Object)content.length);
            return content;
        }
        throw new IOException("ERR_HTTP_RESPONSE:" + responseCode + " URL: " + url);
    }

    private static void setTrustAll(HttpsURLConnection https) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext trustAllSSLContext = SSLContext.getInstance("TLSv1.2");
            trustAllSSLContext.init(null, trustAllCerts, new SecureRandom());
            https.setSSLSocketFactory(trustAllSSLContext.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.catching((Throwable)e);
        }
    }

    public static int getFinalCert(X509Certificate[] chain) {
        int i;
        if (chain == null || chain.length == 0) {
            return -1;
        }
        if (chain.length > 1) {
            for (int i2 = 0; i2 < chain.length; ++i2) {
                X509Certificate cert = chain[i2];
                if (cert.getBasicConstraints() != -1 || CertUtils.getIssuerCertificate(chain, cert) == null) continue;
                return i2;
            }
        } else if (chain.length == 1 && chain[0].getBasicConstraints() == -1) {
            return 0;
        }
        int ca = CertUtils.getCACert(chain);
        int s = CertUtils.getRootCert(chain);
        if (ca != -1) {
            for (i = 0; i < chain.length; ++i) {
                if (i == ca || i == s || !CertUtils.isIssuer(chain[i], chain[ca])) continue;
                return i;
            }
        }
        if (s != -1) {
            for (i = 0; i < chain.length; ++i) {
                if (i == ca || i == s || !chain[i].getIssuerX500Principal().equals(chain[s].getSubjectX500Principal())) continue;
                return i;
            }
        }
        return chain.length > 0 ? (ca == -1 || s == -1 ? 0 : -1) : -1;
    }

    public static int getCACert(X509Certificate[] chain) {
        int i;
        int s = CertUtils.getRootCert(chain);
        if (s != -1) {
            for (i = 0; i < chain.length; ++i) {
                if (i == s || chain[i].getBasicConstraints() == -1 || !CertUtils.isIssuer(chain[i], chain[s])) continue;
                return i;
            }
        }
        for (i = 0; i < chain.length; ++i) {
            if (CertUtils.isSelfSigned(chain[i]) || chain[i].getBasicConstraints() == -1) continue;
            return i;
        }
        return -1;
    }

    public static int getRootCert(X509Certificate[] chain) {
        int i;
        for (i = 0; i < chain.length; ++i) {
            if (!CertUtils.isRootCert(chain[i])) continue;
            return i;
        }
        for (i = 0; i < chain.length; ++i) {
            if (!CertUtils.isSelfSigned(chain[i]) || chain[i].getBasicConstraints() == -1) continue;
            return i;
        }
        return -1;
    }

    public static boolean isRootCert(X509Certificate cur) {
        String subjectCN;
        boolean hasKeyCertSignUsage;
        boolean bl = hasKeyCertSignUsage = cur.getKeyUsage() != null && cur.getKeyUsage().length >= 6 && cur.getKeyUsage()[5];
        if (cur.getBasicConstraints() != -1 && hasKeyCertSignUsage && (subjectCN = CertUtils.getSubjectCN(cur)) != null) {
            return CertUtils.isSelfSigned(cur) && CertResourceHandler.getHandler().isRootCert(cur);
        }
        return false;
    }

    public static String getSubjectCN(X509Certificate cert) {
        return CertUtils.getSubjectValue(cert.getSubjectX500Principal().toString(), "CN");
    }

    public static String getSubjectValue(String subject, String value) {
        if (subject != null) {
            String[] split = subject.split(", ");
            for (int i = 0; i < split.length; ++i) {
                String[] s = split[i].split("=");
                if (!s[0].equals(value)) continue;
                return s[1];
            }
        }
        return null;
    }

    public static boolean isSelfSigned(X509Certificate cur) {
        return cur.getSubjectX500Principal().equals(cur.getIssuerX500Principal());
    }

    public static X509Certificate getFirstCertificate(X509Certificate[] chain, Function<X509Certificate, Boolean> op) {
        for (int i = 0; i < chain.length; ++i) {
            if (!op.apply(chain[i]).booleanValue()) continue;
            return chain[i];
        }
        return null;
    }

    public static boolean isCertIssuedByANF(X509Certificate[] chain) {
        return CertUtils.getRootCert(chain) != -1 || chain.length == 1 && CertUtils.getIssuerCertificate(chain[0]) != null;
    }

    public static X509Certificate[] sortChain(X509Certificate[] certificateChain) {
        int length = certificateChain.length;
        if (length == 1) {
            return certificateChain;
        }
        int finalCert = CertUtils.getFinalCert(certificateChain);
        if (finalCert != -1) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            X509Certificate cert = certificateChain[finalCert];
            while (cert != null) {
                X509Certificate issuerCertificate;
                certs.add(cert);
                if (CertUtils.isSelfSigned(cert) || (issuerCertificate = CertUtils.getIssuerCertificate(certificateChain, cert, true)) == null) break;
                cert = issuerCertificate;
            }
            if (certs.size() != certificateChain.length) {
                certificateChain = new X509Certificate[certs.size()];
            }
            certs.toArray(certificateChain);
        }
        return certificateChain;
    }

    public static X509Certificate[] toX509(Certificate[] chain) {
        X509Certificate[] chain2 = new X509Certificate[chain.length];
        for (int i = 0; i < chain2.length; ++i) {
            if (!(chain[i] instanceof X509Certificate)) {
                return null;
            }
            chain2[i] = (X509Certificate)chain[i];
        }
        return chain2;
    }

    public static Certificate[] toCert(X509Certificate[] chain) {
        Certificate[] chain2 = new Certificate[chain.length];
        for (int i = 0; i < chain2.length; ++i) {
            chain2[i] = chain[i];
        }
        return chain2;
    }

    public static X509Certificate[] convertCertificateHoldersToCertificates(X509CertificateHolder[] holders) {
        X509Certificate[] result = new X509Certificate[holders.length];
        for (int i = 0; i < holders.length; ++i) {
            try {
                result[i] = new JcaX509CertificateConverter().setProvider("SUN").getCertificate(holders[i]);
                continue;
            }
            catch (CertificateException ex) {
                return null;
            }
        }
        return result;
    }

    public static String getSANMailAddress(X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> san = certificate.getSubjectAlternativeNames();
        for (List<?> list : san) {
            String mail;
            Integer type;
            Object obj;
            if (list.size() != 2 || !((obj = list.get(0)) instanceof Integer) || (type = (Integer)obj) != 1 || !((obj = list.get(1)) instanceof String) || (mail = (String)obj).isBlank() || !CertUtils.isValidEmailAddress(mail.trim())) continue;
            return mail;
        }
        return null;
    }

    public static boolean isValidEmailAddress(String email) {
        return Pattern.compile("^[A-Za-z0-9+_.-]+@(.+)$").matcher(email).matches();
    }

    public static List<String> getSubjectAlternativeNames(X509Certificate certificate) {
        ArrayList<String> identities = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
            for (List<?> item : altNames) {
                Integer type = (Integer)item.get(0);
                if (type == 0 || type == 2) {
                    try {
                        ASN1InputStream decoder = null;
                        if (item.toArray()[1] instanceof byte[]) {
                            decoder = new ASN1InputStream((byte[])item.toArray()[1]);
                        } else if (item.toArray()[1] instanceof String) {
                            identities.add((String)item.toArray()[1]);
                        }
                        if (decoder == null) continue;
                        ASN1Primitive encoded = decoder.readObject();
                        encoded = ((ASN1Sequence)encoded).getObjectAt(1);
                        encoded = ((ASN1TaggedObject)encoded).getLoadedObject();
                        encoded = ((ASN1TaggedObject)encoded).getLoadedObject();
                        String identity = ((DERUTF8String)encoded).getString();
                        identities.add(identity);
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error("Error decoding subjectAltName" + e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        log.error("Error decoding subjectAltName" + e.getLocalizedMessage(), (Throwable)e);
                    }
                    continue;
                }
                log.error("SubjectAltName of invalid type found: " + certificate);
            }
        }
        catch (CertificateParsingException e) {
            e.printStackTrace();
            log.error("Error parsing SubjectAltName in certificate: " + certificate + "\r\nerror:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return identities;
    }

    public static List<String> getPolicyOids(X509Certificate cert) {
        ArrayList<String> policyOids = new ArrayList<String>();
        byte[] value = cert.getExtensionValue(Extension.certificatePolicies.getId());
        if (value != null) {
            byte[] octets = ASN1OctetString.getInstance((Object)value).getOctets();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)octets);
            CertUtils.fillPoliciesOids(seq, policyOids);
        }
        return policyOids;
    }

    private static void fillPoliciesOids(ASN1Sequence seq, List<String> policyOids) {
        Enumeration objects = seq.getObjects();
        while (objects.hasMoreElements()) {
            Object object = objects.nextElement();
            if (object instanceof ASN1Sequence) {
                CertUtils.fillPoliciesOids((ASN1Sequence)object, policyOids);
                continue;
            }
            if (!(object instanceof ASN1ObjectIdentifier)) continue;
            policyOids.add(((ASN1ObjectIdentifier)object).getId());
        }
    }

    public static X509Certificate[] getCertificatesPEM(InputStream in) throws IOException, CertificateException, CMSException {
        X509Certificate[] chain = null;
        try (PemReader r = new PemReader((Reader)new InputStreamReader(in));){
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            PemObject pemObj = null;
            while ((pemObj = r.readPemObject()) != null) {
                byte[] content;
                if (pemObj.getType().equals("CERTIFICATE") || pemObj.getType().equals("X509 CERTIFICATE")) {
                    content = pemObj.getContent();
                    X509CertificateHolder certHolder = new X509CertificateHolder(content);
                    X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                    certs.add(cert);
                    continue;
                }
                if (!pemObj.getType().equals("PKCS7")) continue;
                content = pemObj.getContent();
                chain = CertUtils.getCertificates(new ByteArrayInputStream(content));
                chain = CertUtils.sortChain(chain);
                chain = CertUtils.buildChain(chain);
            }
            if (!certs.isEmpty() && chain == null) {
                chain = new X509Certificate[certs.size()];
                certs.toArray(chain);
                chain = CertUtils.sortChain(chain);
                X509Certificate[] x509CertificateArray = chain = CertUtils.buildChain(chain);
                return x509CertificateArray;
            }
        }
        return chain;
    }

    public static String getCRLURL(X509Certificate certificate) throws CertificateParsingException {
        DistributionPoint[] dists;
        ASN1Primitive obj;
        try {
            obj = CertUtils.getExtensionValue(certificate, Extension.cRLDistributionPoints.getId());
        }
        catch (IOException e) {
            obj = null;
        }
        if (obj == null) {
            return null;
        }
        CRLDistPoint dist = CRLDistPoint.getInstance((Object)obj);
        for (DistributionPoint p : dists = dist.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName distributionPointName = p.getDistributionPoint();
            if (0 != distributionPointName.getType()) continue;
            GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
            for (GeneralName name : names = generalNames.getNames()) {
                if (name.getTagNo() != 6) continue;
                ASN1IA5String derStr = ASN1IA5String.getInstance((ASN1TaggedObject)((ASN1TaggedObject)name.toASN1Primitive()), (boolean)false);
                return derStr.getString();
            }
        }
        return null;
    }

    public static ASN1Primitive getExtensionValue(X509Certificate certificate, String oid) throws IOException {
        byte[] bytes = certificate.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        try (ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));){
            ASN1Primitive aSN1Primitive;
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            try (ASN1InputStream aIn2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));){
                aSN1Primitive = aIn2.readObject();
            }
            return aSN1Primitive;
        }
    }

    static {
        AgregarProveedor.agregarBouncyCastleProvider();
        issuerCache = new TreeMap<String, X509Certificate>();
    }
}

