/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.DetailedReportFacade;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.DiagnosticDataFacade;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.validation.reports.DSSReportException;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import org.xml.sax.SAXException;

public abstract class AbstractReports {
    protected boolean validateXml = false;
    private final DiagnosticData diagnosticDataWrapper;
    private final DetailedReport detailedReportWrapper;
    private String xmlDiagnosticData;
    private String xmlDetailedReport;

    protected AbstractReports(XmlDiagnosticData diagnosticDataJaxb, XmlDetailedReport detailedReport) {
        this.diagnosticDataWrapper = new DiagnosticData(diagnosticDataJaxb);
        this.detailedReportWrapper = new DetailedReport(detailedReport);
    }

    public void setValidateXml(boolean validateXml) {
        this.validateXml = validateXml;
    }

    public DiagnosticData getDiagnosticData() {
        return this.diagnosticDataWrapper;
    }

    public DetailedReport getDetailedReport() {
        return this.detailedReportWrapper;
    }

    public XmlDiagnosticData getDiagnosticDataJaxb() {
        return this.diagnosticDataWrapper.getJaxbModel();
    }

    public XmlDetailedReport getDetailedReportJaxb() {
        return this.detailedReportWrapper.getJAXBModel();
    }

    public abstract String getXmlSimpleReport();

    public String getXmlDiagnosticData() {
        try {
            if (this.xmlDiagnosticData == null) {
                this.xmlDiagnosticData = DiagnosticDataFacade.newFacade().marshall((Object)this.getDiagnosticDataJaxb(), this.validateXml);
            }
            return this.xmlDiagnosticData;
        }
        catch (JAXBException | IOException | SAXException e) {
            throw new DSSReportException("An error occurred during marshalling of JAXB Diagnostic Data", e);
        }
    }

    public String getXmlDetailedReport() throws DSSReportException {
        try {
            if (this.xmlDetailedReport == null) {
                this.xmlDetailedReport = DetailedReportFacade.newFacade().marshall((Object)this.getDetailedReportJaxb(), this.validateXml);
            }
            return this.xmlDetailedReport;
        }
        catch (JAXBException | IOException | SAXException e) {
            throw new DSSReportException("An error occurred during marshalling of JAXB Detailed Report", e);
        }
    }

    public void print() {
        System.out.println("----------------Diagnostic data-----------------");
        System.out.println(this.getXmlDiagnosticData());
        System.out.println("----------------Validation report---------------");
        System.out.println(this.getXmlDetailedReport());
        System.out.println("----------------Simple report-------------------");
        System.out.println(this.getXmlSimpleReport());
        System.out.println("------------------------------------------------");
    }
}

