/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByCertificatePostEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByCertificatePreEIDAS;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDByTL;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;

public final class QSCDStrategyFactory {
    private QSCDStrategyFactory() {
    }

    public static QSCDStrategy createQSCDFromCert(CertificateWrapper signingCertificate) {
        if (EIDASUtils.isPostEIDAS(signingCertificate.getNotBefore())) {
            return new QSCDByCertificatePostEIDAS(signingCertificate);
        }
        return new QSCDByCertificatePreEIDAS(signingCertificate);
    }

    public static QSCDStrategy createQSCDFromTL(TrustServiceWrapper trustService, CertificateQualifiedStatus qualified, QSCDStrategy qscdFromCertificate) {
        return new QSCDByTL(trustService, qualified, qscdFromCertificate);
    }

    public static QSCDStrategy createQSCDFromCertAndTL(CertificateWrapper signingCertificate, TrustServiceWrapper caQcTrustService, CertificateQualifiedStatus qualified) {
        QSCDStrategy qscdFromCert = QSCDStrategyFactory.createQSCDFromCert(signingCertificate);
        return QSCDStrategyFactory.createQSCDFromTL(caQcTrustService, qualified, qscdFromCert);
    }
}

