/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.Model;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CertificateValidationBeforeSunsetDateWithIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CheckSubXCVResult;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainAtValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustServiceStatusCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustServiceTypeIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.SubX509CertificateValidation;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class X509CertificateValidation
extends Chain<XmlXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Date usageTime;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Context context, ValidationPolicy validationPolicy) {
        this(i18nProvider, currentCertificate, currentTime, currentTime, context, validationPolicy);
    }

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Date usageTime, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlXCV());
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.usageTime = usageTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.X509_CERTIFICATE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlXCV> item = this.firstItem = this.prospectiveCertificateChain();
        Object trustAnchorCandidate = this.currentCertificate;
        List certificateChain = this.currentCertificate.getCertificateChain();
        SubContext subContext = SubContext.SIGNING_CERT;
        Iterator certChainIt = Utils.isCollectionNotEmpty((Collection)certificateChain) ? certificateChain.iterator() : null;
        CertificateWrapper trustAnchor = null;
        do {
            if (trustAnchorCandidate.isTrusted() && trustAnchorCandidate.getTrustStartDate() != null || trustAnchorCandidate.getTrustSunsetDate() != null) {
                item = item.setNextItem(this.validationBeforeSunsetDate((CertificateWrapper)trustAnchorCandidate, subContext, this.currentTime));
            }
            if (this.isTrustAnchorReached((CertificateWrapper)trustAnchorCandidate, subContext)) {
                item = item.setNextItem(this.prospectiveCertificateChainValidAtValidationTime((CertificateWrapper)trustAnchorCandidate, subContext, this.currentTime));
                trustAnchor = trustAnchorCandidate;
                break;
            }
            trustAnchorCandidate = certChainIt != null && certChainIt.hasNext() ? (CertificateWrapper)certChainIt.next() : null;
            subContext = SubContext.CA_CERTIFICATE;
        } while (trustAnchorCandidate != null);
        if (this.currentCertificate.isTrusted() || this.currentCertificate.isTrustedChain() || !this.prospectiveCertificateChainCheckEnforced()) {
            Date lastDate;
            item = item.setNextItem(this.trustServiceWithExpectedTypeIdentifier());
            item = item.setNextItem(this.trustServiceWithExpectedStatus());
            SubX509CertificateValidation certificateValidation = new SubX509CertificateValidation(this.i18nProvider, this.currentCertificate, this.currentTime, this.currentTime, this.context, SubContext.SIGNING_CERT, this.validationPolicy);
            XmlSubXCV subXCV = (XmlSubXCV)certificateValidation.execute();
            ((XmlXCV)this.result).getSubXCV().add(subXCV);
            item = this.currentCertificate.isTrusted() ? item.setNextItem(this.checkTrustAnchorSubXCVResult(subXCV)) : item.setNextItem(this.checkSubXCVResult(subXCV));
            if (trustAnchor != null && trustAnchor == this.currentCertificate) {
                return;
            }
            Model model = this.validationPolicy.getValidationModel();
            Date date = lastDate = Model.SHELL.equals((Object)model) ? this.currentTime : this.currentCertificate.getNotBefore();
            if (Utils.isCollectionNotEmpty((Collection)certificateChain)) {
                for (CertificateWrapper certificate : certificateChain) {
                    certificateValidation = new SubX509CertificateValidation(this.i18nProvider, certificate, lastDate, this.currentTime, this.context, SubContext.CA_CERTIFICATE, this.validationPolicy);
                    subXCV = (XmlSubXCV)certificateValidation.execute();
                    ((XmlXCV)this.result).getSubXCV().add(subXCV);
                    item = certificate.isTrusted() ? item.setNextItem(this.checkTrustAnchorSubXCVResult(subXCV)) : item.setNextItem(this.checkSubXCVResult(subXCV));
                    Date date2 = Model.HYBRID.equals((Object)model) ? lastDate : (lastDate = Model.SHELL.equals((Object)model) ? this.currentTime : certificate.getNotBefore());
                    if (trustAnchor == null || trustAnchor != certificate) continue;
                    return;
                }
            }
        }
    }

    private ChainItem<XmlXCV> prospectiveCertificateChain() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck<XmlXCV>(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.context, constraint);
    }

    private ChainItem<XmlXCV> validationBeforeSunsetDate(CertificateWrapper certificate, SubContext subContext, Date validationTime) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new CertificateValidationBeforeSunsetDateWithIdCheck<XmlXCV>(this.i18nProvider, (XmlXCV)this.result, certificate, validationTime, ValidationProcessUtils.getConstraintOrMaxLevel(constraint, Level.WARN));
    }

    private ChainItem<XmlXCV> prospectiveCertificateChainValidAtValidationTime(CertificateWrapper certificate, SubContext subContext, Date validationTime) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new ProspectiveCertificateChainAtValidationTimeCheck(this.i18nProvider, (XmlXCV)this.result, certificate, validationTime, constraint);
    }

    private ChainItem<XmlXCV> trustServiceWithExpectedTypeIdentifier() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustServiceTypeIdentifierConstraint(this.context);
        return new TrustServiceTypeIdentifierCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustServiceWithExpectedStatus() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustServiceStatusConstraint(this.context);
        return new TrustServiceStatusCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> checkSubXCVResult(XmlSubXCV subXCVResult) {
        return new CheckSubXCVResult(this.i18nProvider, (XmlXCV)this.result, subXCVResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlXCV> checkTrustAnchorSubXCVResult(XmlSubXCV subXCVResult) {
        return new CheckSubXCVResult(this.i18nProvider, (XmlXCV)this.result, subXCVResult, this.getFailLevelConstraint()){

            @Override
            protected MessageTag getErrorMessageTag() {
                return MessageTag.BBB_XCV_SUB_ANS_2;
            }

            @Override
            protected Indication getFailedIndicationForConclusion() {
                return Indication.INDETERMINATE;
            }

            @Override
            protected SubIndication getFailedSubIndicationForConclusion() {
                return SubIndication.NO_CERTIFICATE_CHAIN_FOUND_NO_POE;
            }
        };
    }

    private boolean prospectiveCertificateChainCheckEnforced() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return constraint != null && Level.FAIL == constraint.getLevel();
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, Context context, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSunsetDateConstraint(context, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, this.currentTime, constraint);
    }

    private boolean isTrustAnchorReached(CertificateWrapper certificateWrapper, SubContext subContext) {
        return this.isTrustAnchor(certificateWrapper, this.context, subContext) || certificateWrapper.isTrusted() && !certificateWrapper.isTrustedChain();
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.SUB_XCV_TA.equals((Object)constraint.getBlockType())) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlSubXCV subXCV : ((XmlXCV)this.result).getSubXCV()) {
            this.collectAllMessages(conclusion, subXCV.getConclusion());
            for (XmlConstraint constraint : subXCV.getConstraint()) {
                if (!XmlBlockType.SUB_XCV_TA.equals((Object)constraint.getBlockType())) continue;
                if (constraint.getError() != null) {
                    this.removeMessage(conclusion.getErrors(), constraint.getError().getKey());
                }
                if (constraint.getWarning() != null) {
                    this.removeMessage(conclusion.getWarnings(), constraint.getWarning().getKey());
                }
                if (constraint.getInfo() == null) continue;
                this.removeMessage(conclusion.getInfos(), constraint.getInfo().getKey());
            }
        }
    }

    private void removeMessage(List<XmlMessage> messages, String messageKey) {
        if (Utils.isCollectionEmpty(messages)) {
            return;
        }
        messages.removeIf(xmlMessage -> messageKey.equals(xmlMessage.getKey()));
    }
}

