/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import eu.europa.esig.dss.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final CryptographicConstraint constraint;

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        this.constraint = constraint;
    }

    public boolean isEncryptionAlgorithmReliable(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm != null && this.constraint != null) {
            ListAlgo acceptableEncryptionAlgos = this.constraint.getAcceptableEncryptionAlgo();
            Algo algo = this.getMatchingAlgo(acceptableEncryptionAlgos, encryptionAlgorithm);
            return algo != null;
        }
        return false;
    }

    public boolean isDigestAlgorithmReliable(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null && this.constraint != null) {
            ListAlgo acceptableDigestAlgos = this.constraint.getAcceptableDigestAlgo();
            Algo algo = this.getMatchingAlgo(acceptableDigestAlgos, digestAlgorithm);
            return algo != null;
        }
        return false;
    }

    public boolean isEncryptionAlgorithmWithKeySizeReliable(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = this.parseKeySize(keyLength);
        return this.isEncryptionAlgorithmWithKeySizeReliable(encryptionAlgorithm, keySize);
    }

    public boolean isEncryptionAlgorithmWithKeySizeReliable(EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        if (encryptionAlgorithm != null && keySize != 0 && this.constraint != null) {
            Integer size = this.getAlgoKeySizeFromConstraint(encryptionAlgorithm);
            return size == null || size <= keySize;
        }
        return false;
    }

    private Integer getAlgoKeySizeFromConstraint(EncryptionAlgorithm encryptionAlgorithm) {
        ListAlgo miniPublicKeySizeEncryptionAlgos;
        Algo algo;
        if (this.constraint != null && (algo = this.getMatchingAlgo(miniPublicKeySizeEncryptionAlgos = this.constraint.getMiniPublicKeySize(), encryptionAlgorithm)) != null) {
            return algo.getSize();
        }
        return null;
    }

    public Date getExpirationDate(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = this.parseKeySize(keyLength);
        return this.getExpirationDate(encryptionAlgorithm, keySize);
    }

    public Date getExpirationDate(EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        Map.Entry floorEntry;
        List<Algo> matchingAlgos;
        TreeMap<Integer, Date> dates = new TreeMap<Integer, Date>();
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && Utils.isCollectionNotEmpty(matchingAlgos = this.getMatchingAlgos((ListAlgo)algoExpirationDates, encryptionAlgorithm))) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            for (Algo algo : matchingAlgos) {
                dates.put(algo.getSize(), this.getDate(algo, dateFormat));
            }
        }
        if ((floorEntry = dates.floorEntry(keySize)) == null) {
            return null;
        }
        return (Date)floorEntry.getValue();
    }

    public Date getExpirationDate(DigestAlgorithm digestAlgorithm) {
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && digestAlgorithm != null) {
            List<Algo> matchingAlgos = this.getMatchingAlgos((ListAlgo)algoExpirationDates, digestAlgorithm);
            if (Utils.collectionSize(matchingAlgos) == 0) {
                return null;
            }
            if (Utils.collectionSize(matchingAlgos) == 1) {
                SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
                return this.getDate(matchingAlgos.iterator().next(), dateFormat);
            }
            throw new IllegalArgumentException(String.format("Multiple expiration constraints are provided for the same digest algorithm '%s'!", digestAlgorithm.getName()));
        }
        return null;
    }

    private int parseKeySize(String keyLength) {
        return Utils.isStringDigits((String)keyLength) ? Integer.parseInt(keyLength) : 0;
    }

    private AlgoExpirationDate getAlgoExpirationDates() {
        if (this.constraint != null) {
            return this.constraint.getAlgoExpirationDate();
        }
        return null;
    }

    private SimpleDateFormat getUsedDateFormat(AlgoExpirationDate expirations) {
        return new SimpleDateFormat(Utils.isStringEmpty((String)expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
    }

    private Date getDate(Algo algo, SimpleDateFormat format) {
        if (algo != null) {
            return this.getDate(algo.getDate(), format);
        }
        return null;
    }

    private Date getDate(String dateString, SimpleDateFormat format) {
        if (dateString != null) {
            try {
                return format.parse(dateString);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)dateString, (Object)format);
            }
        }
        return null;
    }

    public List<DigestAlgorithm> getReliableDigestAlgorithmsAtTime(Date validationTime) {
        ListAlgo acceptableDigestAlgo;
        ArrayList<DigestAlgorithm> reliableDigestAlgorithms = new ArrayList<DigestAlgorithm>();
        if (this.constraint != null && (acceptableDigestAlgo = this.constraint.getAcceptableDigestAlgo()) != null) {
            List acceptableDigestAlgorithmNames = acceptableDigestAlgo.getAlgos().stream().map(Algo::getValue).collect(Collectors.toList());
            AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
            for (String algorithmName : acceptableDigestAlgorithmNames) {
                DigestAlgorithm digestAlgorithm = this.toDigestAlgorithm(algorithmName);
                if (!this.isReliableDigestAlgorithm(digestAlgorithm, algoExpirationDate, validationTime)) continue;
                reliableDigestAlgorithms.add(digestAlgorithm);
            }
        }
        return reliableDigestAlgorithms;
    }

    private DigestAlgorithm toDigestAlgorithm(String algorithmName) {
        try {
            return DigestAlgorithm.forName((String)algorithmName);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to parse a DigestAlgorithm with name '{}'! Reason : {}", new Object[]{algorithmName, e.getMessage(), e});
            return null;
        }
    }

    private boolean isReliableDigestAlgorithm(DigestAlgorithm digestAlgorithm, AlgoExpirationDate algoExpirationDates, Date validationTime) {
        if (digestAlgorithm != null && algoExpirationDates != null) {
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!digestAlgorithm.getName().equals(algo.getValue())) continue;
                Date expirationDate = this.getExpirationDate(digestAlgorithm);
                return expirationDate == null || !this.getExpirationDate(digestAlgorithm).before(validationTime);
            }
        }
        return true;
    }

    public Map<EncryptionAlgorithm, Integer> getReliableEncryptionAlgorithmsWithMinimalKeyLengthAtTime(Date validationTime) {
        ListAlgo acceptableEncryptionAlgo;
        EnumMap<EncryptionAlgorithm, Integer> reliableEncryptionAlgorithms = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
        if (this.constraint != null && (acceptableEncryptionAlgo = this.constraint.getAcceptableEncryptionAlgo()) != null) {
            List acceptableEncryptionAlgorithmNames = acceptableEncryptionAlgo.getAlgos().stream().map(Algo::getValue).collect(Collectors.toList());
            AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
            for (String algorithmName : acceptableEncryptionAlgorithmNames) {
                EncryptionAlgorithm encryptionAlgorithm = this.toEncryptionAlgorithm(algorithmName);
                if (!this.isReliableEncryptionAlgorithm(encryptionAlgorithm, algoExpirationDate, validationTime)) continue;
                Integer minReliableKeySize = this.getMinReliableKeySize(encryptionAlgorithm, algoExpirationDate, validationTime);
                reliableEncryptionAlgorithms.put(encryptionAlgorithm, minReliableKeySize);
            }
        }
        return reliableEncryptionAlgorithms;
    }

    private EncryptionAlgorithm toEncryptionAlgorithm(String algorithmName) {
        return EncryptionAlgorithm.forName((String)algorithmName);
    }

    private boolean isReliableEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm, AlgoExpirationDate algoExpirationDates, Date validationTime) {
        boolean algoFound = false;
        if (encryptionAlgorithm != null && algoExpirationDates != null) {
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!encryptionAlgorithm.getName().equals(algo.getValue())) continue;
                Date expirationDate = this.getExpirationDate(encryptionAlgorithm, algo.getSize());
                if (expirationDate == null || !expirationDate.before(validationTime)) {
                    return true;
                }
                algoFound = algoFound || algo.getDate() != null;
            }
        }
        return !algoFound;
    }

    private Integer getMinReliableKeySize(EncryptionAlgorithm encryptionAlgorithm, AlgoExpirationDate algoExpirationDates, Date validationTime) {
        Integer minimalAcceptedKeySize = null;
        if (encryptionAlgorithm != null && algoExpirationDates != null) {
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!encryptionAlgorithm.getName().equals(algo.getValue()) || minimalAcceptedKeySize == null && algo.getDate() == null) continue;
                Date expirationDate = this.getExpirationDate(encryptionAlgorithm, algo.getSize());
                if (!this.isEncryptionAlgorithmWithKeySizeReliable(encryptionAlgorithm, algo.getSize()) || expirationDate != null && expirationDate.before(validationTime) || minimalAcceptedKeySize != null && algo.getSize() >= minimalAcceptedKeySize) continue;
                minimalAcceptedKeySize = algo.getSize();
            }
        }
        Integer minKeySizeLimit = this.getAlgoKeySizeFromConstraint(encryptionAlgorithm);
        if (minimalAcceptedKeySize == null || minKeySizeLimit != null && minKeySizeLimit > minimalAcceptedKeySize) {
            minimalAcceptedKeySize = minKeySizeLimit;
        }
        return minimalAcceptedKeySize;
    }

    private Algo getMatchingAlgo(ListAlgo listAlgo, EncryptionAlgorithm encryptionAlgorithm) {
        List<Algo> matchingAlgos = this.getMatchingAlgos(listAlgo, encryptionAlgorithm);
        if (Utils.isCollectionNotEmpty(matchingAlgos)) {
            return matchingAlgos.iterator().next();
        }
        return null;
    }

    private List<Algo> getMatchingAlgos(ListAlgo listAlgo, EncryptionAlgorithm encryptionAlgorithm) {
        ArrayList<Algo> result = new ArrayList<Algo>();
        if (listAlgo != null && encryptionAlgorithm != null) {
            for (Algo algo : listAlgo.getAlgos()) {
                if (!algo.getValue().equals(encryptionAlgorithm.getName())) continue;
                result.add(algo);
            }
        }
        return result;
    }

    private Algo getMatchingAlgo(ListAlgo listAlgo, DigestAlgorithm digestAlgorithm) {
        List<Algo> matchingAlgos = this.getMatchingAlgos(listAlgo, digestAlgorithm);
        if (Utils.isCollectionNotEmpty(matchingAlgos)) {
            return matchingAlgos.iterator().next();
        }
        return null;
    }

    private List<Algo> getMatchingAlgos(ListAlgo listAlgo, DigestAlgorithm digestAlgorithm) {
        ArrayList<Algo> result = new ArrayList<Algo>();
        if (listAlgo != null) {
            for (Algo algo : listAlgo.getAlgos()) {
                if (!algo.getValue().equals(digestAlgorithm.getName())) continue;
                result.add(algo);
            }
        }
        return result;
    }

    public Level getLevel() {
        if (this.constraint != null) {
            return this.constraint.getLevel();
        }
        return null;
    }

    public LevelConstraint getAcceptableEncryptionAlgoLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAcceptableEncryptionAlgo());
        }
        return null;
    }

    public LevelConstraint getMiniPublicKeySizeLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getMiniPublicKeySize());
        }
        return null;
    }

    public LevelConstraint getAcceptableDigestAlgoLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAcceptableDigestAlgo());
        }
        return null;
    }

    public LevelConstraint getAlgoExpirationDateLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAlgoExpirationDate());
        }
        return null;
    }

    private LevelConstraint getCryptographicLevelConstraint(LevelConstraint cryptoConstraint) {
        if (cryptoConstraint != null && cryptoConstraint.getLevel() != null) {
            return cryptoConstraint;
        }
        return this.constraint;
    }

    public Date getCryptographicSuiteUpdateDate() {
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            return this.getDate(algoExpirationDates.getUpdateDate(), dateFormat);
        }
        return null;
    }

    public Level getAlgoExpirationDateAfterUpdateLevel() {
        AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
        if (algoExpirationDate != null && algoExpirationDate.getLevelAfterUpdate() != null) {
            return algoExpirationDate.getLevelAfterUpdate();
        }
        LevelConstraint levelConstraint = this.getCryptographicLevelConstraint((LevelConstraint)algoExpirationDate);
        return levelConstraint != null ? levelConstraint.getLevel() : null;
    }

    public CryptographicConstraint getConstraint() {
        return this.constraint;
    }
}

