/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.CertificatePolicy;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;

public final class CertificatePolicyIdentifiers {
    private CertificatePolicyIdentifiers() {
    }

    public static boolean isSupportedByQSCD(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicy.QCP_PUBLIC_WITH_SSCD, CertificatePolicy.QCP_LEGAL_QSCD, CertificatePolicy.QCP_NATURAL_QSCD);
    }

    public static boolean isQCP(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicy.QCP_PUBLIC);
    }

    public static boolean isQCPPlus(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicy.QCP_PUBLIC_WITH_SSCD);
    }

    public static boolean isLegal(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicy.QCP_LEGAL, CertificatePolicy.QCP_LEGAL_QSCD);
    }

    public static boolean isNatural(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicy.QCP_NATURAL, CertificatePolicy.QCP_NATURAL_QSCD);
    }

    private static boolean hasPolicyIdOIDs(CertificateWrapper certificate, CertificatePolicy ... certificatePolicyIds) {
        List policyIds = certificate.getPolicyIds();
        if (Utils.isCollectionNotEmpty((Collection)policyIds)) {
            for (CertificatePolicy policyId : certificatePolicyIds) {
                if (!policyIds.contains(policyId.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

