/*
 * Decompiled with CFR 0.152.
 */
package link;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import link.DiskStatus;
import utils.Utilities;

public class SMILink {
    final int FAIL = 0;
    final int NO_FAIL = 1;
    final int MODE_NOT_SUPPORTED = 16;
    final int OPENDISK_FAIL = 17;
    final int RESVAREA_OVER = 18;
    final int SWWRITEPROTECT = 19;
    final int CHOOSE_WRONG_OPTION = 20;
    public static String DLL_NAME = "ANFuToken";
    public static double WAIT_WRITE_FACTOR = 1.0E-4;
    public static double WAIT_READ_FACTOR = 5.0E-5;
    private static final int MAX_BUFFER_SECTORS = 127;
    public static final int SECTOR_SIZE = 512;

    public SMILink() {
        System.loadLibrary(DLL_NAME);
    }

    public synchronized native boolean loadSMI();

    public synchronized native String getSerialNumber(char var1);

    public synchronized native boolean setSerialNumber(char var1, String var2);

    public synchronized native String getChipName(char var1);

    public synchronized native boolean login(String var1, char var2);

    public synchronized native boolean logout(char var1);

    public synchronized native char[] getSysInfo(String var1, String var2);

    public synchronized native boolean changePassword(String var1, String var2, String var3, char var4);

    public synchronized native String getHint(char var1);

    public synchronized native boolean clearPassword(String var1, String var2, char var3);

    public static double toMB(long lbaSize) {
        return (double)lbaSize / 2048.0;
    }

    public static long toLBA(double mbSize) {
        return (long)(mbSize * 2048.0);
    }

    public synchronized native DiskStatus getDiskCurrentMode(char var1);

    private synchronized native int setDiskCurrentModeWithLabel(long var1, long var3, long var5, long var7, int var9, char var10, String var11, String var12, String var13);

    public int doLBAFormat(long publicLBA, long securityLBA, long indLunLBA, long reservAreaLBA, int diskStatus, char letter, String publicLabel, String securityLabel, String public0Label) {
        DiskStatus dm = this.getDiskCurrentMode(letter);
        if (publicLBA <= 0L || securityLBA < 0L || indLunLBA < 0L) {
            return 0;
        }
        if (reservAreaLBA < 0L) {
            reservAreaLBA = 0L;
        }
        if (reservAreaLBA >= dm.totalLBA) {
            return 18;
        }
        int r = this.setDiskCurrentModeWithLabel(publicLBA, securityLBA, indLunLBA, reservAreaLBA, diskStatus, letter, publicLabel, securityLabel, public0Label);
        return r;
    }

    public int doFormat(double publicMB, double securityMB, double indLunMB, double reservAreaMB, int diskStatus, char letter, String publicLabel, String securityLabel, String public0Label) {
        return this.doLBAFormat(SMILink.toLBA(publicMB), SMILink.toLBA(securityMB), SMILink.toLBA(indLunMB), SMILink.toLBA(reservAreaMB), diskStatus, letter, publicLabel, securityLabel, public0Label);
    }

    public synchronized native boolean forceChangePassword(String var1, String var2, char var3);

    public synchronized native boolean getLockStatus(char var1);

    public synchronized native boolean doSafeRemove(char var1);

    public synchronized native char getRelatedLetter(char var1);

    public synchronized native String[] getFileList(char var1, String var2);

    public File[] readReservToDir(char letter, String dir, String outputDir) {
        ArrayList<File> flist = new ArrayList<File>();
        String[] rf = this.getFileList(letter, dir);
        File outDir = new File(outputDir);
        if (outDir.exists()) {
            for (int i = 0; i < rf.length; ++i) {
                String fi = rf[i];
                String[] split = fi.split("\t");
                String fname = split[0].trim();
                String finfo = split[1].trim();
                if (finfo.equals("DIR")) {
                    File fdir = new File(outDir.getAbsolutePath() + File.separator + fname);
                    if (fdir.exists() && !Utilities.deleteDir(fdir) || !fdir.mkdir()) continue;
                    File[] sub = this.readReservToDir(letter, dir + fname + "\\", fdir.getAbsolutePath());
                    if (sub.length == 0) {
                        flist.add(fdir);
                    }
                    for (int j = 0; j < sub.length; ++j) {
                        flist.add(sub[j]);
                    }
                    continue;
                }
                File file = new File(outputDir + File.separator + fname);
                if (this.readFileReserv(letter, file.getAbsolutePath(), fname, dir)) {
                    flist.add(file);
                    continue;
                }
                System.err.println("Error: El archivo " + file + " no se pudo escribir a partir del archivo " + dir + fname + " de la particion oculta");
            }
        }
        File[] arr = new File[flist.size()];
        return flist.toArray(arr);
    }

    public String[] writeReservFromDir(char letter, String inputDir, String dir) {
        ArrayList<Object> flist = new ArrayList<Object>();
        File inDir = new File(inputDir);
        if (inDir.exists()) {
            File[] lf = inDir.listFiles();
            for (int i = 0; i < lf.length; ++i) {
                File fi = lf[i];
                String dirName = dir + fi.getName() + (fi.isDirectory() ? "\\" : "");
                if (this.checkReservFileOrDirExist(letter, dir + fi.getName()) && !this.deleteFileOrDir(letter, dirName, false, "")) continue;
                if (fi.isDirectory()) {
                    if (!this.createReservDir(letter, dirName)) continue;
                    String[] s = this.writeReservFromDir(letter, fi.getAbsolutePath(), dirName);
                    if (s.length == 0) {
                        flist.add(dirName);
                    }
                    for (int j = 0; j < s.length; ++j) {
                        flist.add(s[j]);
                    }
                    continue;
                }
                if (!fi.isFile()) continue;
                this.getFileList(letter, dir);
                if (!this.writeFileToReserv(letter, fi, dir)) continue;
                flist.add(dir + fi.getName());
            }
        }
        String[] arr = new String[flist.size()];
        return flist.toArray(arr);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized native long getFileSize(char var1, String var2);

    public synchronized native long getDirSize(char var1, String var2);

    public synchronized native long getReservOccupiedSize(char var1);

    public synchronized native long getReservFreeSize(char var1);

    public synchronized native boolean checkReservFileExist(char var1, String var2);

    public synchronized boolean checkReservFileOrDirExist(char letter, String fileName) {
        if (fileName.endsWith(File.separator)) {
            fileName = fileName.substring(0, fileName.length() - File.separator.length());
        }
        return this.checkReservFileExist(letter, fileName);
    }

    public synchronized native boolean createReservDir(char var1, String var2);

    public synchronized native boolean initReserv(char var1, long var2);

    public synchronized native boolean deleteFileOrDir(char var1, String var2, boolean var3, String var4);

    private synchronized native boolean writeFileToReserv(char var1, String var2, String var3, String var4, boolean var5, String var6);

    public boolean writeFileToReserv(char letter, File file, String dir) {
        if (this.getReservFreeSize(letter) < file.length()) {
            return false;
        }
        if (file.exists() && !this.v(file.getAbsolutePath().replace("" + File.separatorChar, "").replace(":", ""))) {
            return false;
        }
        if (!this.v(file.getName())) {
            return false;
        }
        boolean r = this.writeFileToReserv(letter, file.getAbsolutePath(), file.getName(), dir, false, "");
        if (r) {
            String fn = dir + file.getName();
            int min = Math.max(50, (int)((double)file.length() * WAIT_WRITE_FACTOR));
            this.sleep(min);
            do {
                this.sleep(50);
            } while (!this.checkReservFileOrDirExist(letter, fn));
        }
        return r;
    }

    private boolean v(String path) {
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (Character.isLetterOrDigit(c) || this.isSign(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isSign(char c) {
        String s = "!@#$%^&()_+-={}[]';,. ";
        return "!@#$%^&()_+-={}[]';,. ".indexOf(c) != -1;
    }

    private synchronized native boolean writeFileFromBufferToReserv(char var1, byte[] var2, String var3, String var4, boolean var5, String var6);

    public boolean writeFileFromBufferToReserv(char letter, byte[] buffer, String fileName, String dir) {
        if ((long)buffer.length > this.getReservFreeSize(letter)) {
            return false;
        }
        if (!dir.isEmpty() && !this.checkReservFileOrDirExist(letter, dir)) {
            return false;
        }
        if (!this.v(fileName)) {
            return false;
        }
        return this.writeFileFromBufferToReserv(letter, buffer, fileName, dir, true, "");
    }

    private synchronized native boolean saveFileReserv(char var1, String var2, String var3, String var4, boolean var5, String var6);

    public boolean readFileReserv(char letter, String filePath, String fileName, String dir) {
        if (this.checkReservFileOrDirExist(letter, fileName) && !this.v(fileName)) {
            return false;
        }
        if (!this.v(dir)) {
            return false;
        }
        String fn = dir + fileName;
        long fileSize = this.getFileSize(letter, fn);
        boolean r = this.saveFileReserv(letter, filePath, fileName, dir, true, "");
        if (r) {
            int min = Math.max(50, (int)((double)fileSize * WAIT_READ_FACTOR));
            this.sleep(min);
            do {
                this.sleep(50);
            } while (!new File(filePath).exists() || new File(filePath).length() < fileSize);
        }
        return r;
    }

    public synchronized native byte[] readFileReservToBuffer(char var1, String var2, String var3, String var4);

    public synchronized native byte[] readFileReservToSubBuffer(char var1, String var2, String var3, long var4, long var6, String var8);

    public synchronized native boolean changeReservPassword(char var1, String var2, String var3);

    public synchronized native boolean setReservHint(char var1, String var2);

    public synchronized native String getReservHint(char var1);

    public synchronized native int getReservSize(char var1);

    private synchronized native byte[] readReservSectorsToBuffer(char var1, int var2, int var3);

    public byte[] readHiddenSectorsToBuffer(char letter, int startSector, int length) {
        if (startSector + length > this.getReservBufferSectorsSize(letter)) {
            return null;
        }
        return this.readReservSectorsToBuffer(letter, startSector, length);
    }

    private synchronized native boolean writeReservSectorsFromBuffer(char var1, int var2, byte[] var3);

    public boolean writeReservSectorsFromBuffer(char letter, int startSector, byte[] buffer, boolean writeComplete) {
        if (writeComplete) {
            if (512 * startSector + buffer.length <= this.getReservBufferSectorsSize(letter) * 512) {
                return this.writeReservSectorsFromBuffer(letter, startSector, buffer);
            }
        } else {
            int bytes = 512 * (this.getReservBufferSectorsSize(letter) - startSector);
            if (buffer.length <= bytes) {
                return this.writeReservSectorsFromBuffer(letter, startSector, buffer);
            }
            return this.writeReservSectorsFromBuffer(letter, startSector, Arrays.copyOf(buffer, bytes));
        }
        return false;
    }

    public int getReservBufferSectorsSize(char letter) {
        return Math.min(this.getReservSize(letter) - 1, 127);
    }

    public synchronized native boolean writeToCDROM(String var1, boolean var2, char var3);

    public synchronized native char[] getCDROMLetter();

    public static boolean format(String unit) {
        if (unit != null) {
            try {
                Process proc = Runtime.getRuntime().exec(String.format("cmd /c format.com %s /BACKUP /FS:NTFS /Q /X /V:eSign-ANF-AC", unit.replace(File.separator, "")));
                proc.waitFor();
                InputStream e = proc.getInputStream();
                int available = e.available();
                byte[] arr = new byte[available];
                e.read(arr, 0, available);
                String error = new String(arr);
                System.out.println(error);
                return proc.exitValue() == 0;
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

