/*
 * Decompiled with CFR 0.152.
 */
package iso;

import iso.ISOGeneral;
import java.io.File;
import java.io.InputStream;

public class PowerISO
extends ISOGeneral {
    @Override
    protected String getCreateDAACommand(String daaName, String inputDir, String outputDir, String pass) {
        return this.buildCommand("piso.exe", "create", "-ot", "daa", "-setpassword", pass, "-o", this.b(outputDir + File.separator + daaName), "-add", this.b(inputDir), "/");
    }

    @Override
    protected String getCreateISOCommand(String isoName, File[] inputFiles, String outputDir) {
        String[] arr = new String[4 + 3 * inputFiles.length];
        arr[0] = "piso.exe";
        arr[1] = "create";
        arr[2] = "-o";
        arr[3] = this.b(outputDir + File.separator + isoName);
        for (int i = 0; i < inputFiles.length; ++i) {
            arr[4 + 3 * i] = "-add";
            arr[4 + 3 * i + 1] = this.b(inputFiles[i].getAbsolutePath());
            arr[4 + 3 * i + 2] = inputFiles[i].isDirectory() ? this.b("/" + inputFiles[i].getName()) : "/";
        }
        return this.buildCommand(arr);
    }

    @Override
    protected String getCreateISOCommand(String isoName, String inputDir, String outputDir) {
        return this.buildCommand("piso.exe", "create", "-o", this.b(outputDir + File.separator + isoName), "-add", this.b(inputDir), "/");
    }

    @Override
    protected String getMountISOCommand(String inputISOName, File disk) {
        return this.buildCommand("piso.exe", "mount", this.b(inputISOName), this.b(disk.getAbsolutePath()));
    }

    @Override
    protected String getExtractISOCommand(String inputISOName, String outputDirName) {
        return this.buildCommand("piso.exe", "extract", this.b(inputISOName), "/", "-od", this.b(outputDirName));
    }

    @Override
    protected InputStream getStream() {
        return this.exec.getInputStream();
    }

    @Override
    protected boolean preExecute(int action, String ... args) {
        if (action == 0) {
            if (args.length < 2) {
                return false;
            }
            int si = 0;
            if (args.length == 3) {
                si = 1;
            }
            String outputDirName = args[si];
            String isoFile = args[si + 1];
            File file = new File(outputDirName + File.separator + isoFile);
            int n = 0;
            while (file.exists()) {
                file.delete();
                if (++n != 100) continue;
                System.exit(1);
            }
            return true;
        }
        if (action == 1) {
            if (args.length == 2) {
                for (int i = 0; i < args.length; ++i) {
                    if (new File(args[i]).exists()) continue;
                    return false;
                }
                return true;
            }
        } else if (action == 2 && args.length == 2) {
            for (int i = 0; i < args.length; ++i) {
                if (new File(args[i]).exists()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void readPercent(String error) {
        System.out.println(error);
        String l = error.trim();
        int ind = l.lastIndexOf("%");
        double p = 0.0;
        if (ind > 0) {
            int i = ind;
            while (--i >= 0 && l.charAt(i) != ' ') {
            }
            if (i >= 0) {
                try {
                    p = Double.parseDouble(l.substring(i, ind));
                    this.setPercent(p);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

