/*
 * Decompiled with CFR 0.152.
 */
package iso;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import link.SMILink;
import utils.Utilities;

public abstract class ISOGeneral
implements Runnable {
    protected static final int CREATE_ISO = 0;
    protected static final int EXTRACT_ISO = 1;
    protected static final int MOUNT_ISO = 2;
    protected Process exec;
    protected double percent;
    protected String message;
    protected volatile boolean endProccess = false;

    protected String buildCommand(String ... args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i] + (i < args.length - 1 ? " " : ""));
        }
        return sb.toString();
    }

    public synchronized void setMessage(String message) {
        this.message = message;
        this.notifyAll();
    }

    public synchronized void setPercent(double p) {
        this.percent = p;
        this.notifyAll();
    }

    protected void sleep(long i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.exec == null) {
            this.sleep(100L);
        }
        while (true) {
            this.sleep(100L);
            try {
                try {
                    if (this.exec.exitValue() == 0) {
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updatePercent();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract String getCreateISOCommand(String var1, String var2, String var3);

    protected abstract String getCreateDAACommand(String var1, String var2, String var3, String var4);

    protected abstract String getCreateISOCommand(String var1, File[] var2, String var3);

    protected abstract String getExtractISOCommand(String var1, String var2);

    protected abstract String getMountISOCommand(String var1, File var2);

    protected void updatePercent() throws IOException {
        String error = this.readStream();
        this.readPercent(error);
    }

    protected abstract void readPercent(String var1);

    protected abstract InputStream getStream();

    protected String readStream() throws IOException {
        InputStream e = this.getStream();
        int available = e.available();
        byte[] arr = new byte[available];
        e.read(arr, 0, available);
        String error = new String(arr);
        return error;
    }

    public double getPercent() {
        return this.percent;
    }

    public boolean updateCDROM(char cdLetter, String inputDirPath, String isoPath, String backupISO, SMILink link) {
        this.setEndProccess(false);
        File inputDir = new File(inputDirPath);
        if (inputDir.exists() && link != null) {
            File isoFile = null;
            isoFile = isoPath == null ? this.getTempISOFile() : new File(isoPath);
            this.setPercent(0.0);
            this.setMessage("Creando imagen ISO del directorio origen");
            int createISO = this.createISO(inputDir, isoFile.getParentFile(), isoFile.getName());
            this.setPercent(0.0);
            if (createISO == 0) {
                char letter = cdLetter;
                boolean writeToCDROM = false;
                if (letter != '\u0000') {
                    File cd;
                    if (backupISO != null && (cd = new File(letter + ":")).exists()) {
                        File backupFile = null;
                        backupFile = new File(backupISO);
                        this.setPercent(0.0);
                        this.setMessage("Creando imagen ISO del CD-ROM");
                        int createCDISO = this.createISO(cd.listFiles(), backupFile.getParentFile(), backupFile.getName());
                        this.setPercent(0.0);
                        if (createCDISO != 0) {
                            this.setEndProccess(true);
                            return false;
                        }
                    }
                    this.setMessage("Extrayendo imagen ISO en el CD-ROM");
                    writeToCDROM = link.writeToCDROM(isoFile.getAbsolutePath(), true, letter);
                    this.setPercent(100.0);
                }
                if (isoPath == null) {
                    isoFile.delete();
                }
                this.setEndProccess(true);
                return writeToCDROM;
            }
        }
        this.setEndProccess(true);
        return false;
    }

    private File getTempISOFile() {
        File isoFile = null;
        String isoPath = System.getProperty("user.home") + File.separator + "temp";
        Object code = "";
        int c = 0;
        do {
            isoFile = new File(isoPath + (String)code + ".iso");
            code = "" + ++c;
        } while (isoFile.exists());
        return isoFile;
    }

    public int extractISOToPublic(char letter, File inputISO, SMILink link) {
        if (!link.logout(letter)) {
            return -1;
        }
        return this.extractToDisk(letter, inputISO);
    }

    public int extractISOToPrivate(char letter, String password, File inputISO, SMILink link) {
        if (!link.login(password, letter)) {
            return -1;
        }
        return this.extractToDisk(letter, inputISO);
    }

    private int extractToDisk(char letter, File inputISO) {
        File disk = new File(letter + ":");
        String isoName = inputISO.getName();
        if (isoName.endsWith(".iso")) {
            isoName = isoName.substring(0, isoName.length() - 4);
        }
        File dir = new File(disk.getAbsoluteFile() + File.separator + isoName);
        int x = 0;
        while (dir.exists()) {
            dir = new File(disk.getAbsoluteFile() + File.separator + isoName + x);
            ++x;
        }
        if (disk.exists() && (!dir.exists() || Utilities.deleteDir(dir)) && dir.mkdir()) {
            int extractISO = this.extractISO(inputISO, dir);
            if (extractISO == 0) {
                Utilities.moveDirContentToDir(dir, disk);
            }
            Utilities.deleteDir(dir);
            return extractISO;
        }
        return -1;
    }

    public int extractISOToReserv(char letter, String dir, String tempDir, File inputISO, SMILink link) {
        File temp = null;
        temp = tempDir == null ? this.getTempDir() : new File(tempDir);
        int createISO = this.extractISO(inputISO, temp);
        String[] r = link.writeReservFromDir(letter, temp.getAbsolutePath(), dir);
        Utilities.deleteDir(temp);
        if (r.length > 0) {
            return createISO;
        }
        return -1;
    }

    public int createISOFromPrivate(char letter, String password, File outputDir, String isoName, SMILink link) {
        if (!link.login(password, letter)) {
            return -1;
        }
        return this.createISOFromDisk(letter, outputDir, isoName);
    }

    public int createISOFromPublic(char letter, File outputDir, String isoName, SMILink link) {
        if (!link.logout(letter)) {
            return -1;
        }
        return this.createISOFromDisk(letter, outputDir, isoName);
    }

    private int createISOFromDisk(char letter, File outputDir, String isoName) {
        File disk = new File(letter + ":");
        int createISO = -1;
        if (disk.exists()) {
            File[] listFiles = disk.listFiles();
            createISO = this.createISO(listFiles, outputDir, isoName);
        }
        return createISO;
    }

    public int createISOFromReserv(char letter, String dir, String tempDir, File outputDir, String isoName, SMILink link) {
        File temp = null;
        temp = tempDir == null ? this.getTempDir() : new File(tempDir);
        File[] lf = link.readReservToDir(letter, dir, temp.getAbsolutePath());
        int createISO = -1;
        if (lf.length > 0) {
            createISO = this.createISO(temp, outputDir, isoName);
        }
        Utilities.deleteDir(temp);
        return createISO;
    }

    private File getTempDir() {
        File tempDir = null;
        String isoPath = System.getProperty("user.home") + File.separator + "reserv-temp";
        Object code = "";
        int c = 0;
        do {
            tempDir = new File(isoPath + (String)code);
            code = "" + ++c;
        } while (tempDir.exists());
        tempDir.mkdir();
        return tempDir;
    }

    public int mountISO(File inputISO, File disk) {
        String inputISOName = inputISO.getAbsolutePath();
        String command = this.getMountISOCommand(inputISOName, disk);
        if (this.preExecute(2, inputISOName, disk.getAbsolutePath())) {
            return this.execute(command);
        }
        return -1;
    }

    public int extractISO(File inputISO, File outputDir) {
        String outputDirName = outputDir.getAbsolutePath();
        String inputISOName = inputISO.getAbsolutePath();
        String command = this.getExtractISOCommand(inputISOName, outputDirName);
        if (this.preExecute(1, inputISOName, outputDirName)) {
            return this.execute(command);
        }
        return -1;
    }

    public int createISO(File inputDir, File outputDir, String isoName) {
        String outputDirName = outputDir.getAbsolutePath();
        String isoFile = isoName + (isoName.endsWith(".iso") ? "" : ".iso");
        String inputDirName = inputDir.getAbsolutePath();
        String command = this.getCreateISOCommand(isoFile, inputDirName, outputDirName);
        if (this.preExecute(0, inputDirName, outputDirName, isoFile)) {
            return this.execute(command);
        }
        return -1;
    }

    public int createDAA(File inputDir, File outputDir, String isoName, String pass) {
        String outputDirName = outputDir.getAbsolutePath();
        String isoFile = isoName + (isoName.endsWith(".daa") ? "" : ".daa");
        String inputDirName = inputDir.getAbsolutePath();
        String command = this.getCreateDAACommand(isoFile, inputDirName, outputDirName, pass);
        if (this.preExecute(0, inputDirName, outputDirName, isoFile)) {
            int execute = this.execute(command);
            if (execute == 0) {
                command = this.buildCommand("piso.exe", "convert", outputDirName + File.separator + isoFile, "-o", outputDirName + File.separator + "test.iso", "-ot", "iso");
                execute = this.execute(command);
            }
            return execute;
        }
        return -1;
    }

    public int createISO(File[] inputFiles, File outputDir, String isoName) {
        String outputDirName = outputDir.getAbsolutePath();
        String isoFile = isoName + (isoName.endsWith(".iso") ? "" : ".iso");
        File[] list = new File[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            if (!inputFiles[i].exists()) continue;
            list[i] = inputFiles[i];
        }
        String command = this.getCreateISOCommand(isoFile, list, outputDirName);
        if (this.preExecute(0, outputDirName, isoFile)) {
            return this.execute(command);
        }
        return -1;
    }

    protected abstract boolean preExecute(int var1, String ... var2);

    private int execute(String command) {
        if (command != null) {
            try {
                String outFile = new File("").getAbsolutePath() + File.separator + "out.bat";
                new File(outFile).exists();
                this.exec = Runtime.getRuntime().exec(command);
                InputStream e = this.exec.getInputStream();
                int available = e.available();
                byte[] arr = new byte[available];
                e.read(arr, 0, available);
                String error = new String(arr);
                new Thread(this).start();
                this.exec.waitFor();
                this.setPercent(100.0);
                return this.exec.exitValue();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    protected String b(String a) {
        return "\"" + a + "\"";
    }

    public String getMessage() {
        return this.message;
    }

    public synchronized boolean endProccess() {
        return this.endProccess;
    }

    public synchronized void setEndProccess(boolean f) {
        this.endProccess = f;
        this.notifyAll();
    }
}

