/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JNIPanel;
import iso.ISOGeneral;
import iso.PowerISO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import link.SMILink;

public class UpdateCDROMPanel
extends JNIPanel {
    private static final long serialVersionUID = 1L;
    JPanel inputDirL = new JPanel(null);
    JPanel inputISOL = new JPanel(null);
    JPanel backUpISOL = new JPanel(null);
    JTextField inputDirT = new JTextField(new File("").getAbsolutePath());
    JTextField inputISOT = new JTextField(new File("").getAbsolutePath());
    JTextField backupISOT = new JTextField(new File("").getAbsolutePath());
    JTextField backupISONameT = new JTextField();
    JTextField inputISONameT = new JTextField();
    JLabel inputISONameL = new JLabel("Nombre de la imagen:");
    JLabel backupISONameL = new JLabel("Nombre de la imagen:");
    JLabel cdLetterL = new JLabel("Letra del CD:");
    JButton browseInputDir = new JButton("Examinar...");
    JButton browseInputISO = new JButton("Examinar...");
    JButton browseBackupISO = new JButton("Examinar...");
    JButton refreshCD = new JButton("Refrescar");
    JButton updateCD = new JButton("Actualizar CD-ROM");
    JCheckBox createISOCB = new JCheckBox("Guardar ISO a grabar en CD-ROm");
    JCheckBox backupISOCB = new JCheckBox("Crear ISO del CD-ROM");
    JComboBox combo = new JComboBox();
    JProgressBar bar = new JProgressBar(0, 100);
    SMILink link = new SMILink();
    ISOGeneral iso = new PowerISO();
    private char cdl = '\u0000';

    public UpdateCDROMPanel(boolean run, boolean start) {
        super(run, start);
        this.add(this.inputDirL);
        this.add(this.inputISOL);
        this.add(this.backUpISOL);
        this.inputDirL.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Directorio origen:", 2, 2));
        this.inputISOL.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Guardar imagen a grabar en CD-ROM", 2, 2));
        this.backUpISOL.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Imagen de resguardo:", 2, 2));
        this.inputDirL.add(this.browseInputDir);
        this.inputDirL.add(this.inputDirT);
        this.inputISOL.add(this.inputISOT);
        this.inputISOL.add(this.browseInputISO);
        this.inputISOL.add(this.createISOCB);
        this.inputISOL.add(this.inputISONameL);
        this.inputISOL.add(this.inputISONameT);
        this.backUpISOL.add(this.backupISOT);
        this.backUpISOL.add(this.backupISOCB);
        this.backUpISOL.add(this.browseBackupISO);
        this.backUpISOL.add(this.backupISONameL);
        this.backUpISOL.add(this.backupISONameT);
        this.add(this.refreshCD);
        this.add(this.combo);
        this.add(this.cdLetterL);
        this.add(this.updateCD);
        this.add(this.bar);
        this.bar.setString("Progreso");
        this.bar.setStringPainted(true);
        this.createISOCB.setSelected(false);
        this.backupISOCB.setSelected(false);
        this.inputDirT.setEditable(false);
        this.inputISOT.setEditable(false);
        this.backupISOT.setEditable(false);
        this.actions();
        this.enableAction();
        this.refresh();
    }

    @Override
    protected void actions() {
        this.createISOCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UpdateCDROMPanel.this.enableAction();
            }
        });
        this.backupISOCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UpdateCDROMPanel.this.enableAction();
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateCDROMPanel.this.cdl = ((Character)UpdateCDROMPanel.this.combo.getSelectedItem()).charValue();
                UpdateCDROMPanel.this.enableAction();
            }
        });
        this.refreshCD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateCDROMPanel.this.refresh();
            }
        });
        this.browseInputDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v;
                JFileChooser opener = new JFileChooser(".");
                opener.setFileSelectionMode(1);
                opener.setMultiSelectionEnabled(false);
                opener.setAcceptAllFileFilterUsed(false);
                File dir = new File(UpdateCDROMPanel.this.inputDirT.getText());
                if (dir.exists()) {
                    opener.setCurrentDirectory(dir);
                }
                if ((v = opener.showOpenDialog(UpdateCDROMPanel.this)) == 0 && opener.getSelectedFile() != null && opener.getSelectedFile().exists() && opener.getSelectedFile().isDirectory()) {
                    File[] listFiles = opener.getSelectedFile().listFiles();
                    if (listFiles == null || listFiles.length == 0) {
                        JOptionPane.showMessageDialog(UpdateCDROMPanel.this, "El directorio est? vac?o", "Error", 0);
                    } else {
                        UpdateCDROMPanel.this.inputDirT.setText(opener.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        });
        this.browseBackupISO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v;
                JFileChooser opener = new JFileChooser(".");
                opener.setFileSelectionMode(1);
                opener.setMultiSelectionEnabled(false);
                opener.setAcceptAllFileFilterUsed(false);
                File dir = new File(UpdateCDROMPanel.this.backupISOT.getText());
                if (dir.exists()) {
                    opener.setCurrentDirectory(dir);
                }
                if ((v = opener.showOpenDialog(UpdateCDROMPanel.this)) == 0 && opener.getSelectedFile() != null && opener.getSelectedFile().exists() && opener.getSelectedFile().isDirectory()) {
                    File[] listFiles = opener.getSelectedFile().listFiles();
                    if (listFiles == null || listFiles.length == 0) {
                        JOptionPane.showMessageDialog(UpdateCDROMPanel.this, "El directorio est? vac?o", "Error", 0);
                    } else {
                        UpdateCDROMPanel.this.backupISOT.setText(opener.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        });
        this.browseInputISO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v;
                JFileChooser opener = new JFileChooser(".");
                opener.setFileSelectionMode(1);
                opener.setMultiSelectionEnabled(false);
                opener.setAcceptAllFileFilterUsed(false);
                File dir = new File(UpdateCDROMPanel.this.inputISOT.getText());
                if (dir.exists()) {
                    opener.setCurrentDirectory(dir);
                }
                if ((v = opener.showOpenDialog(UpdateCDROMPanel.this)) == 0 && opener.getSelectedFile() != null && opener.getSelectedFile().exists() && opener.getSelectedFile().isDirectory()) {
                    File[] listFiles = opener.getSelectedFile().listFiles();
                    if (listFiles == null || listFiles.length == 0) {
                        JOptionPane.showMessageDialog(UpdateCDROMPanel.this, "El directorio est? vac?o", "Error", 0);
                    } else {
                        UpdateCDROMPanel.this.inputISOT.setText(opener.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        });
        this.updateCD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        String dir = UpdateCDROMPanel.this.validateDir(UpdateCDROMPanel.this.inputDirT.getText());
                        if (dir != null) {
                            boolean updateCDROM;
                            Object isoName = null;
                            if (UpdateCDROMPanel.this.createISOCB.isSelected()) {
                                isoName = UpdateCDROMPanel.this.inputISONameT.getText();
                                String iso = UpdateCDROMPanel.this.validateDir(UpdateCDROMPanel.this.inputISOT.getText());
                                if (iso != null && !((String)isoName).isEmpty()) {
                                    if (!((String)(isoName = iso + File.separator + (String)isoName)).endsWith(".iso")) {
                                        isoName = (String)isoName + ".iso";
                                    }
                                } else {
                                    isoName = null;
                                }
                            }
                            Object backupName = null;
                            if (UpdateCDROMPanel.this.backupISOCB.isSelected()) {
                                backupName = UpdateCDROMPanel.this.backupISONameT.getText();
                                String backup = UpdateCDROMPanel.this.validateDir(UpdateCDROMPanel.this.backupISOT.getText());
                                if (backup != null && !((String)backupName).isEmpty()) {
                                    if (!((String)(backupName = backup + File.separator + (String)backupName)).endsWith(".iso")) {
                                        backupName = (String)backupName + ".iso";
                                    }
                                } else {
                                    backupName = null;
                                }
                            }
                            if (updateCDROM = UpdateCDROMPanel.this.iso.updateCDROM(UpdateCDROMPanel.this.cdl, dir, (String)isoName, (String)backupName, UpdateCDROMPanel.this.link)) {
                                JOptionPane.showMessageDialog(UpdateCDROMPanel.this, "Se ha actualizado el CD-ROM exitosamente", "Actualizaci?n completada", 1);
                            } else {
                                JOptionPane.showMessageDialog(UpdateCDROMPanel.this, "No se ha actualizado el CD-ROM", "Error", 0);
                            }
                        }
                    }
                }.start();
                new Thread(UpdateCDROMPanel.this).start();
            }
        });
    }

    protected void refresh() {
        char[] letter = this.link.getCDROMLetter();
        this.combo.removeAllItems();
        if (letter != null) {
            for (int i = 0; i < letter.length; ++i) {
                this.combo.addItem(Character.valueOf(letter[i]));
            }
        }
    }

    @Override
    protected void enableAction() {
        this.inputISOT.setEnabled(this.createISOCB.isSelected());
        this.inputISONameT.setEnabled(this.createISOCB.isSelected());
        this.browseInputISO.setEnabled(this.createISOCB.isSelected());
        this.backupISOT.setEnabled(this.backupISOCB.isSelected());
        this.backupISONameT.setEnabled(this.backupISOCB.isSelected());
        this.browseBackupISO.setEnabled(this.backupISOCB.isSelected());
        this.combo.setEnabled(this.combo.getItemCount() > 0);
        this.updateCD.setEnabled(this.combo.getItemCount() > 0);
    }

    @Override
    protected void init() {
        this.setMinimumSize(new Dimension(400, 400));
        this.title = "Actualizar CD-ROM";
        this.setSize(500, 450);
        super.init();
    }

    @Override
    protected void updateBounds() {
        int w = this.getWidth();
        int h = this.getHeight();
        int w2 = w / 2;
        int ww = w - 20;
        this.cdLetterL.setBounds(this.combo.getX() - 80, 20, 80, 20);
        this.combo.setBounds(w2 - 50, 20, 100, 20);
        this.refreshCD.setBounds(this.combo.getX() + this.combo.getWidth() + 10, 20, 100, 20);
        this.inputDirL.setBounds(w2 - ww / 2, 60, ww, 60);
        this.inputISOL.setBounds(w2 - ww / 2, this.inputDirL.getY() + this.inputDirL.getHeight() + 10, ww, 100);
        this.backUpISOL.setBounds(w2 - ww / 2, this.inputISOL.getY() + this.inputISOL.getHeight() + 10, ww, 100);
        ww = w - 180;
        this.inputDirT.setBounds(20, 20, ww, 20);
        this.browseInputDir.setBounds(this.inputDirT.getX() + this.inputDirT.getWidth() + 10, this.inputDirT.getY(), 100, 20);
        ww = 250;
        this.createISOCB.setBounds(w2 - ww / 2, 20, ww, 20);
        ww = w - 180;
        this.inputISOT.setBounds(20, this.createISOCB.getY() + this.createISOCB.getHeight() + 5, ww, 20);
        this.browseInputISO.setBounds(this.inputISOT.getX() + this.inputISOT.getWidth() + 10, this.inputISOT.getY(), 100, 20);
        this.inputISONameL.setBounds(this.inputISOT.getX(), this.inputISOT.getY() + this.inputISOT.getHeight() + 5, 130, 20);
        this.inputISONameT.setBounds(this.inputISONameL.getX() + this.inputISONameL.getWidth(), this.inputISONameL.getY(), this.inputISOT.getWidth() - this.inputISONameL.getWidth(), 20);
        ww = 200;
        this.backupISOCB.setBounds(w2 - ww / 2, 20, ww, 20);
        ww = w - 180;
        this.backupISOT.setBounds(20, this.backupISOCB.getY() + this.backupISOCB.getHeight() + 5, ww, 20);
        this.browseBackupISO.setBounds(this.backupISOT.getX() + this.backupISOT.getWidth() + 10, this.inputISOT.getY(), 100, 20);
        this.backupISONameL.setBounds(this.backupISOT.getX(), this.backupISOT.getY() + this.backupISOT.getHeight() + 5, 130, 20);
        this.backupISONameT.setBounds(this.backupISONameL.getX() + this.backupISONameL.getWidth(), this.backupISONameL.getY(), this.backupISOT.getWidth() - this.backupISONameL.getWidth(), 20);
        ww = 150;
        this.updateCD.setBounds(w / 2 - ww / 2, this.backUpISOL.getY() + this.backUpISOL.getHeight() + 10, ww, 20);
        ww = w - 20;
        this.bar.setBounds(w / 2 - ww / 2, this.updateCD.getY() + this.updateCD.getHeight() + 10, ww, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateDir(String text) {
        File dir = new File(text);
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] listFiles = dir.listFiles();
                if (listFiles != null && listFiles.length != 0) return dir.getAbsolutePath();
                JOptionPane.showMessageDialog(this, "El directorio est? vac?o", "Error", 0);
                return null;
            } else {
                JOptionPane.showMessageDialog(this, "El archivo seleccionado no es un directorio", "Error", 0);
            }
            return null;
        } else {
            JOptionPane.showMessageDialog(this, "El directorio no existe", "Error", 0);
        }
        return null;
    }

    @Override
    public void run() {
        this.sleep();
        this.sleep();
        this.sleep();
        do {
            this.sleep();
            this.bar.setValue((int)this.iso.getPercent());
            this.bar.setString(this.iso.getMessage());
            this.repaint();
        } while (!this.iso.endProccess());
        this.bar.setString("Progreso");
        this.bar.setValue(0);
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jtattoo.plaf.mcwin.McWinLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UpdateCDROMPanel.showFrame(new UpdateCDROMPanel(true, true));
    }

    private static void copyFile() {
        String name = "Presentaci?n(1).mpg";
        File f = new File("h:" + File.separator + name);
        if (f.exists()) {
            try {
                RandomAccessFile r = new RandomAccessFile(f, "r");
                File file = new File("c:" + File.separator + name);
                RandomAccessFile r2 = new RandomAccessFile(file, "rw");
                long l = 1000000L;
                long o = r2.length();
                r2.seek(o);
                byte[] b = new byte[(int)l];
                long fl = r.length();
                if (o < fl) {
                    int i = 0;
                    while ((long)i <= fl / l) {
                        r.seek(o);
                        r.read(b, 0, (int)l);
                        r2.write(b);
                        l = Math.min(fl - (o += l), l);
                        Thread.sleep(2000L);
                        System.out.println("escritos " + o / 1024L / 1024L + " megabytes");
                        ++i;
                    }
                }
                r.close();
                r2.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println();
        }
    }
}

