/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ManifestFile
implements Serializable {
    private static final long serialVersionUID = -5971045309587760817L;
    private DSSDocument document;
    private String signatureFilename;
    private List<ManifestEntry> entries;
    private ASiCManifestTypeEnum manifestType;

    public DSSDocument getDocument() {
        return this.document;
    }

    public void setDocument(DSSDocument document) {
        this.document = document;
    }

    public String getFilename() {
        return this.document.getName();
    }

    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    public byte[] getDigestValue(DigestAlgorithm digestAlgorithm) {
        return this.document.getDigestValue(digestAlgorithm);
    }

    public List<ManifestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ManifestEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
    }

    public ASiCManifestTypeEnum getManifestType() {
        return this.manifestType;
    }

    public void setManifestType(ASiCManifestTypeEnum manifestType) {
        this.manifestType = manifestType;
    }

    public ManifestEntry getRootFile() {
        for (ManifestEntry entry : this.getEntries()) {
            if (!entry.isRootfile()) continue;
            return entry;
        }
        return null;
    }

    public boolean isDocumentCovered(String documentName) {
        if (documentName != null && documentName.length() > 0) {
            for (ManifestEntry entry : this.getEntries()) {
                if (!documentName.equals(entry.getUri())) continue;
                return true;
            }
        }
        return false;
    }
}

