/*
 * Decompiled with CFR 0.152.
 */
package org.kamranzafar.otp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kamranzafar.otp.Configuration;
import org.kamranzafar.otp.OTPProvider;

public class OTPProviderFactory {
    private static final String PROPS_CLASS = "class";
    private static final String PROPS_PROVIDERS = "providers";
    private static final String PROVIDERS = "/org/kamranzafar/otp/providers.properties";
    public static Map<String, OTPProvider> providers = new HashMap<String, OTPProvider>();

    private static void loadProvider(InputStream is) {
        String[] ps;
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String p : ps = props.getProperty(PROPS_PROVIDERS).split(",")) {
            try {
                OTPProvider otpp = (OTPProvider)Class.forName((String)props.get(p + ".class")).newInstance();
                HashMap<String, String> pprops = new HashMap<String, String>();
                Enumeration<Object> keys = props.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    if (!key.startsWith(p + ".") || key.equalsIgnoreCase(p + ".class")) continue;
                    String att = key.substring(key.indexOf(46) + 1);
                    pprops.put(att, props.getProperty(key));
                }
                otpp.setProperties(pprops);
                providers.put(p.toLowerCase(), otpp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static OTPProvider getOTPProvider(String name) {
        return providers.get(name.toLowerCase());
    }

    public static void addProvider(String name, OTPProvider provider) {
        providers.put(name, provider);
    }

    static {
        OTPProviderFactory.loadProvider(OTPProviderFactory.class.getResourceAsStream(PROVIDERS));
        String ext = Configuration.getExternalOTPProviders();
        if (ext != null) {
            try {
                OTPProviderFactory.loadProvider(new FileInputStream(ext));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

