/*
 * Decompiled with CFR 0.152.
 */
package com.anf.autoupdate.view.controller;

import com.anf.autoupdate.client.model.AppVersion;
import com.anf.autoupdate.client.model.FileVersion;
import com.anf.autoupdate.model.UpdateParams;
import com.anf.autoupdate.text.Texts;
import com.anf.autoupdate.view.controller.LaterController;
import com.anf.autoupdate.view.controller.UpdateWindow;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextArea;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateVersionController
implements UpdateWindow {
    private static final Logger log = LogManager.getLogger(UpdateVersionController.class);
    @FXML
    private StackPane stackPane;
    @FXML
    private HBox mainBox;
    @FXML
    private VBox vBox;
    @FXML
    private VBox detailsBox;
    @FXML
    private ImageView icon;
    @FXML
    private Label newVersionAvailable;
    @FXML
    private Label yourVersion;
    @FXML
    private Label yourVersionValue;
    @FXML
    private Label newVersion;
    @FXML
    private Label newVersionValue;
    @FXML
    private Label updates;
    @FXML
    private JFXTextArea updateText;
    @FXML
    private JFXButton updateButton;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private JFXButton laterButton;
    private UpdateParams params;
    private Stage stage;

    @Override
    public void init(UpdateParams params, AppVersion lastVersion, Stage stage) {
        this.stage = stage;
        this.params = params;
        this.newVersionValue.setText(lastVersion.getVersion());
    }

    public void setFileVersions(List<FileVersion> latestVersions) {
        this.cancelButton.setVisible(false);
        this.newVersionAvailable.setText(Texts.getText("new.version.available", new Object[0]));
        this.updates.setText(Texts.getText("updates", new Object[0]));
        this.updateButton.setText(Texts.getText("update", new Object[0]));
        this.cancelButton.setText(Texts.getText("cancel", new Object[0]));
        this.yourVersion.setText(Texts.getText("your.version", new Object[0]));
        this.newVersion.setText(Texts.getText("new.version", new Object[0]));
        this.yourVersionValue.setText(this.params.getVersion());
        this.cancelButton.setOnAction(this::close);
        if (latestVersions != null && !latestVersions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Collections.sort(latestVersions, (f1, f2) -> f2.compareTo((FileVersion)f1));
            TreeSet<String> diff = new TreeSet<String>();
            for (FileVersion fv : latestVersions) {
                String version = fv.getApp().getVersion();
                if (!diff.add(version)) continue;
                sb.append(Texts.getText("version", version)).append("\n");
                sb.append(fv.getApp().getChanges()).append("\n\n");
            }
            this.updateText.setText(sb.toString());
        }
        this.laterButton.setOnAction(this::laterWindow);
    }

    private void close(ActionEvent e) {
        Platform.exit();
        System.exit(0);
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.updateButton.setOnAction(e -> {
            this.stage.hide();
            onUpdate.run();
        });
    }

    private void laterWindow(ActionEvent e) {
        this.showLaterWindow();
    }

    private void showLaterWindow() {
        JFXDialogLayout dialogLayout = new JFXDialogLayout();
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Thread.currentThread().getContextClassLoader().getResource("later.fxml"));
            Pane root = (Pane)loader.load();
            LaterController help = (LaterController)loader.getController();
            help.init(this.params);
            dialogLayout.setBody(new Node[]{root});
            JFXDialog dialog = new JFXDialog(this.stackPane, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER);
            dialog.setOpacity(0.0);
            dialog.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
            dialog.setStyle("-fx-background-color: TRANSPARENT; -fx-background-radius: 25pt; -fx-border-radius: 15; ");
            dialog.show();
        }
        catch (IOException e) {
            log.error("error cargando fxml", (Throwable)e);
        }
    }
}

